/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson.factory;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class TypeFactory {
    public static <T> Type newListTypeToken(Class<T> listType) {
        return TypeFactory.newCollectionTypeToken(List.class, listType);
    }

    public static <T extends Collection, E> Type newCollectionTypeToken(Class<T> collectionClass, Class<E> elementClass) {
        return TypeToken.getParameterized(collectionClass, (Type[])new Type[]{elementClass}).getType();
    }

    public static <T> Type newCollectionTypeToken(Class<T> elementClass) {
        return TypeFactory.newCollectionTypeToken(Collection.class, elementClass);
    }

    public static <M extends Map, K, V> Type newMapTypeToken(Class<M> mapClass, Class<K> keyType, Class<V> valueType) {
        return TypeToken.getParameterized(mapClass, (Type[])new Type[]{keyType, valueType}).getType();
    }

    public static <K, V> Type newMapTypeToken(Class<K> keyType, Class<V> valueType) {
        return TypeFactory.newMapTypeToken(Map.class, keyType, valueType);
    }
}

