/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import de.alpharogroup.gson.factory.GsonFactory;
import de.alpharogroup.gson.factory.TypeFactory;
import java.util.List;
import java.util.Objects;

public final class ObjectToJsonExtensions {
    private ObjectToJsonExtensions() {
    }

    public static <T> String toJson(List<T> list) {
        Objects.requireNonNull(list);
        return ObjectToJsonExtensions.toJson(list, GsonFactory.DEFAULT_GSON);
    }

    public static <T> String toJson(List<T> list, Gson gson) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(gson);
        if (list.isEmpty()) {
            return "";
        }
        return gson.toJson(list, TypeFactory.newListTypeToken(list.get(0).getClass()));
    }

    public static <T> String toJson(T object) {
        Objects.requireNonNull(object);
        return ObjectToJsonExtensions.toJson(object, GsonFactory.DEFAULT_GSON);
    }

    public static <T> String toJson(T object, Gson gson) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(gson);
        return gson.toJson(object, object.getClass());
    }
}

