/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import de.alpharogroup.gson.factory.GsonFactory;
import de.alpharogroup.gson.factory.TypeFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonStringToObjectExtensions {
    private JsonStringToObjectExtensions() {
    }

    public static <K, V> Map<K, V> toMapObject(String jsonString, Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(keyType);
        Objects.requireNonNull(valueType);
        return JsonStringToObjectExtensions.toMapObject(jsonString, keyType, valueType, GsonFactory.DEFAULT_GSON);
    }

    public static <K, V> Map<K, V> toMapObject(String jsonString, Class<K> keyType, Class<V> valueType, Gson gson) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(keyType);
        Objects.requireNonNull(valueType);
        Objects.requireNonNull(gson);
        return (Map)gson.fromJson(jsonString, TypeFactory.newMapTypeToken(keyType, valueType));
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, GsonFactory.DEFAULT_GSON);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, Gson gson) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(gson);
        return (T)gson.fromJson(jsonString, clazz);
    }

    public static <T> Collection<T> toObjectCollection(String jsonString, Class<? extends Collection> collectionClass, Class<T> elementClass) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(collectionClass);
        Objects.requireNonNull(elementClass);
        return JsonStringToObjectExtensions.toObjectCollection(jsonString, collectionClass, elementClass, GsonFactory.DEFAULT_GSON);
    }

    public static <T> Collection<T> toObjectCollection(String jsonString, Class<? extends Collection> collectionClass, Class<T> elementClass, Gson gson) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(collectionClass);
        Objects.requireNonNull(elementClass);
        return (Collection)gson.fromJson(jsonString, TypeFactory.newCollectionTypeToken(collectionClass, elementClass));
    }

    public static <T> List<T> toObjectList(String jsonString, Class<T> elementClass) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(elementClass);
        return (List)JsonStringToObjectExtensions.toObjectCollection(jsonString, List.class, elementClass);
    }
}

