/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.alpharogroup.gson.factory.GsonFactory;
import de.alpharogroup.gson.factory.TypeFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public final class JsonFileToObjectExtensions {
    private JsonFileToObjectExtensions() {
    }

    public static <T> T toObject(File jsonFile, Class<T> clazz) throws IOException {
        return JsonFileToObjectExtensions.toObject(jsonFile, clazz, GsonFactory.DEFAULT_GSON);
    }

    public static <T> T toObject(File jsonFile, Class<T> clazz, Gson gson) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(gson);
        return (T)gson.fromJson((Reader)new FileReader(jsonFile), clazz);
    }

    public static <T> List<T> toObjectList(File jsonListFile, Class<T> clazz) throws IOException {
        Objects.requireNonNull(jsonListFile);
        Objects.requireNonNull(clazz);
        return JsonFileToObjectExtensions.toObjectList(jsonListFile, clazz, GsonFactory.DEFAULT_GSON);
    }

    public static <T> List<T> toObjectList(File jsonListFile, Class<T> clazz, Gson gson) throws IOException {
        Objects.requireNonNull(jsonListFile);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(gson);
        Type listType = TypeFactory.newListTypeToken(clazz);
        JsonReader reader = new JsonReader((Reader)new FileReader(jsonListFile));
        return (List)gson.fromJson(reader, listType);
    }
}

