/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.bean.mapper;

import de.alpharogroup.bean.mapper.GenericMapper;
import de.alpharogroup.bean.mapper.MapperExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.dozer.Mapper;
import org.dozer.MappingException;

public interface DozerGenericMapper<ENTITY, DTO>
extends GenericMapper<ENTITY, DTO> {
    public Class<DTO> getDtoClass();

    public Class<ENTITY> getEntityClass();

    public Mapper getMapper();

    default public <D, S> List<D> map(@NonNull Collection<S> sources, @NonNull Class<D> destinationClass) throws MappingException {
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        if (destinationClass == null) {
            throw new NullPointerException("destinationClass is marked non-null but is null");
        }
        return MapperExtensions.map(this.getMapper(), sources, destinationClass);
    }

    default public <D, S> D map(@NonNull S source, @NonNull Class<D> destinationClass) throws MappingException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destinationClass == null) {
            throw new NullPointerException("destinationClass is marked non-null but is null");
        }
        return MapperExtensions.map(this.getMapper(), source, destinationClass);
    }

    default public DTO toDto(@NonNull ENTITY entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return (DTO)this.getMapper().map(entity, this.getDtoClass());
    }

    default public List<DTO> toDtos(@NonNull Collection<ENTITY> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        ArrayList<DTO> domainObjects = new ArrayList<DTO>();
        if (!entities.isEmpty()) {
            for (ENTITY entity : entities) {
                domainObjects.add(this.toDto(entity));
            }
        }
        return domainObjects;
    }

    default public List<ENTITY> toEntities(@NonNull Collection<DTO> dtos) {
        if (dtos == null) {
            throw new NullPointerException("dtos is marked non-null but is null");
        }
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        if (!dtos.isEmpty()) {
            for (DTO dto : dtos) {
                entities.add(this.toEntity(dto));
            }
        }
        return entities;
    }

    default public ENTITY toEntity(@NonNull DTO dto) {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return (ENTITY)this.getMapper().map(dto, this.getEntityClass());
    }
}

