/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree.ifaces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public interface ITreeNode<T>
extends Serializable {
    default public void addChild(ITreeNode<T> child) {
        child.setParent(this);
        this.getChildren().add(child);
    }

    default public void addChildAt(int index, ITreeNode<T> child) throws IndexOutOfBoundsException {
        if (index < this.getChildren().size()) {
            this.getChildren().add(index, child);
        } else {
            this.addChild(child);
        }
    }

    default public List<ITreeNode<T>> getAllSiblings() {
        ITreeNode<T> parent = this.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<ITreeNode<T>> siblings = new ArrayList<ITreeNode<T>>(parent.getChildren());
        siblings.remove(this);
        return siblings;
    }

    default public int getChildCount() {
        return this.getChildren().size();
    }

    public List<ITreeNode<T>> getChildren();

    default public int getDepth() {
        if (this.isLeaf() || this.getChildCount() == 0) {
            return 0;
        }
        int maxDepth = 1;
        int currentDepth = 1;
        for (ITreeNode<T> data : this.getChildren()) {
            while (data.hasChildren()) {
                ++currentDepth;
                data = data.getChildren().get(0);
            }
            if (maxDepth >= currentDepth) continue;
            maxDepth = currentDepth;
        }
        return maxDepth;
    }

    public String getDisplayValue();

    default public int getLevel() {
        ITreeNode<T> current = this;
        int count = 0;
        while ((current = current.getParent()) != null) {
            ++count;
        }
        return count;
    }

    default public ITreeNode<T> getNextSibling() {
        if (this.getParent() == null) {
            return null;
        }
        int index = this.getParent().getChildren().indexOf(this) + 1;
        if (index == this.getParent().getChildCount()) {
            return null;
        }
        return this.getParent().getChildren().get(index);
    }

    public ITreeNode<T> getParent();

    default public ITreeNode<T> getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        int index = this.getParent().getChildren().indexOf(this) - 1;
        if (index < 0) {
            return null;
        }
        return this.getParent().getChildren().get(index);
    }

    default public ITreeNode<T> getRoot() {
        ITreeNode<T> root = this;
        ITreeNode<T> parent = this.getParent();
        while (parent != null && !parent.isRoot()) {
            root = parent = parent.getParent();
        }
        return root;
    }

    public T getValue();

    default public boolean hasChildren() {
        return this.getChildren() != null && !this.getChildren().isEmpty();
    }

    default public boolean hasParent() {
        return this.getParent() != null;
    }

    default public boolean isLeaf() {
        return !this.isNode();
    }

    default public boolean isNode() {
        return true;
    }

    default public boolean isRoot() {
        return !this.hasParent();
    }

    default public void removeChild(ITreeNode<T> child) {
        this.getChildren().remove(child);
        child.setParent(null);
    }

    default public void removeChildAt(int index) throws IndexOutOfBoundsException {
        ITreeNode<T> child = this.getChildren().remove(index);
        if (child != null) {
            child.setParent(null);
        }
    }

    public void setChildren(List<ITreeNode<T>> var1);

    public void setDisplayValue(String var1);

    public void setParent(ITreeNode<T> var1);

    public void setValue(T var1);

    default public List<ITreeNode<T>> toList() {
        ArrayList<ITreeNode<T>> list = new ArrayList<ITreeNode<T>>();
        this.traverse(this, list);
        return list;
    }

    default public void traverse(ITreeNode<T> node, List<ITreeNode<T>> list) {
        list.add(node);
        for (ITreeNode<T> data : node.getChildren()) {
            this.traverse(data, list);
        }
    }
}

