/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree.ifaces;

import java.util.LinkedList;
import java.util.List;

public interface ILinkedNode<T> {
    default public ILinkedNode<T> getFirst() {
        ILinkedNode<T> first = this;
        ILinkedNode<T> previous = this.getPrevious();
        while (previous != null && !previous.isFirst()) {
            first = previous = previous.getPrevious();
        }
        return first;
    }

    public ILinkedNode<T> getNext();

    default public int getNextCount() {
        return this.getNextLinkedNodes().size();
    }

    default public List<ILinkedNode<T>> getNextLinkedNodes() {
        LinkedList<ILinkedNode<T>> list = new LinkedList<ILinkedNode<T>>();
        ILinkedNode<T> next = this;
        while (next.hasNext()) {
            next = next.getNext();
            list.add(next);
        }
        return list;
    }

    public ILinkedNode<T> getPrevious();

    default public int getPreviousCount() {
        return this.getPreviousLinkedNodes().size();
    }

    default public List<ILinkedNode<T>> getPreviousLinkedNodes() {
        LinkedList<ILinkedNode<T>> list = new LinkedList<ILinkedNode<T>>();
        ILinkedNode<T> previous = this;
        while (previous.hasPrevious()) {
            previous = previous.getPrevious();
            list.add(previous);
        }
        return list;
    }

    public T getValue();

    default public boolean hasNext() {
        return this.getNext() != null;
    }

    default public boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    default public boolean isFirst() {
        return !this.hasPrevious();
    }

    public void setNext(ILinkedNode<T> var1);

    public void setPrevious(ILinkedNode<T> var1);

    public void setValue(T var1);

    default public List<ILinkedNode<T>> toList() {
        LinkedList<ILinkedNode<T>> list = new LinkedList<ILinkedNode<T>>();
        ILinkedNode<T> first = this.getFirst();
        list.add(first);
        ILinkedNode<T> next = first;
        while (next.hasNext()) {
            next = next.getNext();
            list.add(next);
        }
        return list;
    }
}

