/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree.ifaces;

import java.util.LinkedList;
import java.util.List;

public interface IChainableTreeNode<T> {
    default public List<IChainableTreeNode<T>> getAllParent() {
        LinkedList<IChainableTreeNode<T>> list = new LinkedList<IChainableTreeNode<T>>();
        IChainableTreeNode<T> parent = this;
        while (parent.hasParent()) {
            parent = parent.getParent();
            list.add(parent);
        }
        return list;
    }

    public IChainableTreeNode<T> getChild();

    default public int getChildCount() {
        return this.getChildren().size();
    }

    default public List<IChainableTreeNode<T>> getChildren() {
        LinkedList<IChainableTreeNode<T>> list = new LinkedList<IChainableTreeNode<T>>();
        IChainableTreeNode<T> child = this;
        while (child.hasChild()) {
            child = child.getChild();
            list.add(child);
        }
        return list;
    }

    default public int getLevel() {
        return this.getAllParent().size();
    }

    public IChainableTreeNode<T> getParent();

    default public IChainableTreeNode<T> getRoot() {
        IChainableTreeNode<T> root = this;
        IChainableTreeNode<T> parent = this.getParent();
        while (parent != null && !parent.isRoot()) {
            root = parent = parent.getParent();
        }
        return root;
    }

    public T getValue();

    default public boolean hasChild() {
        return this.getChild() != null;
    }

    default public boolean hasParent() {
        return this.getParent() != null;
    }

    default public boolean isRoot() {
        return !this.hasParent();
    }

    public void setChild(IChainableTreeNode<T> var1);

    public void setParent(IChainableTreeNode<T> var1);

    public void setValue(T var1);

    default public List<IChainableTreeNode<T>> toList() {
        LinkedList<IChainableTreeNode<T>> list = new LinkedList<IChainableTreeNode<T>>();
        IChainableTreeNode<T> root = this.getRoot();
        list.add(root);
        IChainableTreeNode<T> child = root;
        while (child.hasChild()) {
            child = child.getChild();
            list.add(child);
        }
        return list;
    }
}

