/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree;

import java.io.Serializable;

public class TreeElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean node;
    private TreeElement parent;

    public static TreeElementBuilder builder() {
        return new TreeElementBuilder();
    }

    public TreeElementBuilder toBuilder() {
        return new TreeElementBuilder().name(this.name).node(this.node).parent(this.parent);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNode() {
        return this.node;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNode(boolean node) {
        this.node = node;
    }

    public void setParent(TreeElement parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeElement)) {
            return false;
        }
        TreeElement other = (TreeElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.isNode() == other.isNode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isNode() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TreeElement(name=" + this.getName() + ", node=" + this.isNode() + ")";
    }

    public TreeElement() {
    }

    public TreeElement(String name, boolean node, TreeElement parent) {
        this.name = name;
        this.node = node;
        this.parent = parent;
    }

    public static class TreeElementBuilder {
        private String name;
        private boolean node;
        private TreeElement parent;

        TreeElementBuilder() {
        }

        public TreeElementBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TreeElementBuilder node(boolean node) {
            this.node = node;
            return this;
        }

        public TreeElementBuilder parent(TreeElement parent) {
            this.parent = parent;
            return this;
        }

        public TreeElement build() {
            return new TreeElement(this.name, this.node, this.parent);
        }

        public String toString() {
            return "TreeElement.TreeElementBuilder(name=" + this.name + ", node=" + this.node + ", parent=" + this.parent + ")";
        }
    }
}

