/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree;

import de.alpharogroup.tree.ifaces.ILinkedNode;

public class LinkedNode<T>
implements ILinkedNode<T> {
    private ILinkedNode<T> next;
    private ILinkedNode<T> previous;
    private T value;

    public static <T> LinkedNodeBuilder<T> builder() {
        return new LinkedNodeBuilder();
    }

    public LinkedNodeBuilder<T> toBuilder() {
        return new LinkedNodeBuilder<T>().next(this.next).previous(this.previous).value(this.value);
    }

    @Override
    public ILinkedNode<T> getNext() {
        return this.next;
    }

    @Override
    public ILinkedNode<T> getPrevious() {
        return this.previous;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setNext(ILinkedNode<T> next) {
        this.next = next;
    }

    @Override
    public void setPrevious(ILinkedNode<T> previous) {
        this.previous = previous;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedNode)) {
            return false;
        }
        LinkedNode other = (LinkedNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ILinkedNode<T> this$next = this.getNext();
        ILinkedNode<T> other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        ILinkedNode<T> this$previous = this.getPrevious();
        ILinkedNode<T> other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !this$previous.equals(other$previous)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkedNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ILinkedNode<T> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        ILinkedNode<T> $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "LinkedNode(previous=" + this.getPrevious() + ", value=" + this.getValue() + ")";
    }

    public LinkedNode() {
    }

    public LinkedNode(ILinkedNode<T> next, ILinkedNode<T> previous, T value) {
        this.next = next;
        this.previous = previous;
        this.value = value;
    }

    public static class LinkedNodeBuilder<T> {
        private ILinkedNode<T> next;
        private ILinkedNode<T> previous;
        private T value;

        LinkedNodeBuilder() {
        }

        public LinkedNodeBuilder<T> next(ILinkedNode<T> next) {
            this.next = next;
            return this;
        }

        public LinkedNodeBuilder<T> previous(ILinkedNode<T> previous) {
            this.previous = previous;
            return this;
        }

        public LinkedNodeBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public LinkedNode<T> build() {
            return new LinkedNode<T>(this.next, this.previous, this.value);
        }

        public String toString() {
            return "LinkedNode.LinkedNodeBuilder(next=" + this.next + ", previous=" + this.previous + ", value=" + this.value + ")";
        }
    }
}

