/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.tree;

import de.alpharogroup.tree.ifaces.IChainableTreeNode;

public class ChainableTreeNode<T>
implements IChainableTreeNode<T> {
    private IChainableTreeNode<T> child;
    private IChainableTreeNode<T> parent;
    private T value;

    public ChainableTreeNode(T value) {
        this.value = value;
    }

    public static <T> ChainableTreeNodeBuilder<T> builder() {
        return new ChainableTreeNodeBuilder();
    }

    public ChainableTreeNodeBuilder<T> toBuilder() {
        return new ChainableTreeNodeBuilder<T>().child(this.child).parent(this.parent).value(this.value);
    }

    @Override
    public IChainableTreeNode<T> getChild() {
        return this.child;
    }

    @Override
    public IChainableTreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setChild(IChainableTreeNode<T> child) {
        this.child = child;
    }

    @Override
    public void setParent(IChainableTreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChainableTreeNode)) {
            return false;
        }
        ChainableTreeNode other = (ChainableTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IChainableTreeNode<T> this$child = this.getChild();
        IChainableTreeNode<T> other$child = other.getChild();
        if (this$child == null ? other$child != null : !this$child.equals(other$child)) {
            return false;
        }
        IChainableTreeNode<T> this$parent = this.getParent();
        IChainableTreeNode<T> other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChainableTreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IChainableTreeNode<T> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : $child.hashCode());
        IChainableTreeNode<T> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ChainableTreeNode(parent=" + this.getParent() + ", value=" + this.getValue() + ")";
    }

    public ChainableTreeNode() {
    }

    public ChainableTreeNode(IChainableTreeNode<T> child, IChainableTreeNode<T> parent, T value) {
        this.child = child;
        this.parent = parent;
        this.value = value;
    }

    public static class ChainableTreeNodeBuilder<T> {
        private IChainableTreeNode<T> child;
        private IChainableTreeNode<T> parent;
        private T value;

        ChainableTreeNodeBuilder() {
        }

        public ChainableTreeNodeBuilder<T> child(IChainableTreeNode<T> child) {
            this.child = child;
            return this;
        }

        public ChainableTreeNodeBuilder<T> parent(IChainableTreeNode<T> parent) {
            this.parent = parent;
            return this;
        }

        public ChainableTreeNodeBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public ChainableTreeNode<T> build() {
            return new ChainableTreeNode<T>(this.child, this.parent, this.value);
        }

        public String toString() {
            return "ChainableTreeNode.ChainableTreeNodeBuilder(child=" + this.child + ", parent=" + this.parent + ", value=" + this.value + ")";
        }
    }
}

