/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gen.src.generator;

import de.alpharogroup.file.FileExtension;
import de.alpharogroup.gen.src.model.ClassGenerationModelBean;
import de.alpharogroup.gen.src.model.PomGenerationModelBean;
import de.alpharogroup.gen.src.model.RepositoryClassModelBean;
import de.alpharogroup.gen.src.model.VelocityTemplatesModelBean;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.PackageExtensions;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import de.alpharogroup.string.StringExtensions;
import de.alpharogroup.velocity.VelocityExtensions;
import de.alpharogroup.xml.XmlExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;

public final class GeneratorExtensions {
    private static final String ENTITIES = "-entities";
    private static final String INIT = "-init";
    private static final String REST_API = "-rest-api";
    private static final String REST_CLIENT = "-rest-client";
    private static final String REST_WEB = "-rest-web";
    public static final String SOURCE_FOLDER_SRC_MAIN_WEBAPP = "src/main/webapp";
    private static final String DATABASE_INITIALIZATION_CLASSNAME = "DatabaseInitialization";
    private static final String INITIALIZE_DATABASE_CLASSNAME = "InitializeDatabase";
    private static final String DB_INIT_PATH = "de/alpharogroup/db/init/";
    private static final String API_PACKAGE_PATH = "/api/";
    private static final String POM_XML_FILENAME = "pom.xml";
    private static final String GITIGNORE_FILENAME = ".gitignore";
    private static final String LOG4J_PROPERTIES_FILENAME = "log4j.properties";
    private static ClassGenerationModelBean classGenerationData;
    private static PomGenerationModelBean pomGenerationData;
    private static VelocityTemplatesModelBean templates;

    public static void generateClasses(ClassGenerationModelBean generator, List<RepositoryClassModelBean> repositoryModels, PomGenerationModelBean pomGenerationData, boolean withProjectPath) throws IOException {
        for (RepositoryClassModelBean model : repositoryModels) {
            VelocityContext context = new VelocityContext();
            context.put("model", (Object)model);
            String repositoryClassPath = generator.getSrcFolder() + generator.getSrcGenerationPackage() + model.getRepositoryClassName() + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRepositoryClass(), GeneratorExtensions.getEntitiesProjectPath(pomGenerationData), repositoryClassPath, withProjectPath);
            String repositoryTestClassPath = generator.getSrcTestFolder() + generator.getSrcTestGenerationPackage() + model.getRepositoryClassName() + "Test" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRepositoryTestClass(), GeneratorExtensions.getInitProjectPath(pomGenerationData), repositoryTestClassPath, withProjectPath);
            String serviceInterfacePath = generator.getSrcFolder() + generator.getSrcServiceGenerationPackage() + API_PACKAGE_PATH + model.getServiceClassName() + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplServiceInterface(), GeneratorExtensions.getBusinessProjectPath(pomGenerationData), serviceInterfacePath, withProjectPath);
            String serviceClassPath = generator.getSrcFolder() + generator.getSrcServiceGenerationPackage() + model.getModelClassName() + "BusinessService" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplServiceClass(), GeneratorExtensions.getBusinessProjectPath(pomGenerationData), serviceClassPath, withProjectPath);
            String serviceTestClassPath = generator.getSrcTestFolder() + generator.getSrcServiceGenerationPackage() + model.getModelClassName() + "BusinessService" + "Test" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplServiceTestClass(), GeneratorExtensions.getInitProjectPath(pomGenerationData), serviceTestClassPath, withProjectPath);
            String domainClassPath = generator.getSrcFolder() + generator.getSrcDomainGenerationPackage() + model.getDomainClassName() + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplDomainClass(), GeneratorExtensions.getDomainProjectPath(pomGenerationData), domainClassPath, withProjectPath);
            String domainMapperClassPath = generator.getSrcFolder() + generator.getSrcDomainMapperGenerationPackage() + model.getModelClassName() + "Mapper" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplDomainMapperClass(), GeneratorExtensions.getDomainProjectPath(pomGenerationData), domainMapperClassPath, withProjectPath);
            String domainServiceInterfacePath = generator.getSrcFolder() + generator.getSrcDomainServiceGenerationPackage() + API_PACKAGE_PATH + model.getDomainServiceClassName() + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplDomainServiceInterface(), GeneratorExtensions.getDomainProjectPath(pomGenerationData), domainServiceInterfacePath, withProjectPath);
            String domainServiceClassPath = generator.getSrcFolder() + generator.getSrcDomainServiceGenerationPackage() + model.getDomainClassName() + "DomainService" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplDomainServiceClass(), GeneratorExtensions.getDomainProjectPath(pomGenerationData), domainServiceClassPath, withProjectPath);
            String restapiResourceInterfacePath = generator.getSrcFolder() + generator.getSrcRestGenerationPackage() + API_PACKAGE_PATH + model.getModelClassName() + "Resource" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRestResourceInterface(), GeneratorExtensions.getRestApiProjectPath(pomGenerationData), restapiResourceInterfacePath, withProjectPath);
            String restapiResourceClassPath = generator.getSrcFolder() + generator.getSrcRestGenerationPackage() + model.getModelClassName() + "RestResource" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRestResourceClass(), GeneratorExtensions.getRestApiProjectPath(pomGenerationData), restapiResourceClassPath, withProjectPath);
            String restClientClassPath = generator.getSrcFolder() + generator.getSrcRestGenerationPackage() + "/client/" + model.getModelClassName() + "RestClient" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRestClientClass(), GeneratorExtensions.getRestClientProjectPath(pomGenerationData), restClientClassPath, withProjectPath);
            String restClientTestClassPath = generator.getSrcTestFolder() + generator.getSrcRestGenerationPackage() + "/client/" + model.getModelClassName() + "RestClient" + "Test" + FileExtension.JAVA.getExtension();
            GeneratorExtensions.mergeProjectFile(context, GeneratorExtensions.getVelocityTemplates().getTmplRestClientTestClass(), GeneratorExtensions.getRestClientProjectPath(pomGenerationData), restClientTestClassPath, withProjectPath);
        }
    }

    public static void generatePomFiles() throws Exception {
        String pomGenerationModel = "PomGenerationModelBean.xml";
        PomGenerationModelBean generationData = GeneratorExtensions.loadPomGenerationModelBean("PomGenerationModelBean.xml");
        GeneratorExtensions.generate(generationData, false);
    }

    public static void generate(PomGenerationModelBean generationData, boolean withClasses) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)generationData);
        String parentProjectPath = GeneratorExtensions.getParentProjectPath(generationData);
        String parentDataPomClassPath = parentProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplDataPom(), (String)parentDataPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(parentProjectPath + "/" + GITIGNORE_FILENAME));
        String businessProjectPath = GeneratorExtensions.getBusinessProjectPath(generationData);
        String businessPomClassPath = businessProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplBusinessPom(), (String)businessPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(businessProjectPath + "/" + GITIGNORE_FILENAME));
        String domainProjectPath = GeneratorExtensions.getDomainProjectPath(generationData);
        String domainPomClassPath = domainProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplDomainPom(), (String)domainPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(domainProjectPath + "/" + GITIGNORE_FILENAME));
        String entitiesProjectPath = GeneratorExtensions.getEntitiesProjectPath(generationData);
        String entitiesPomClassPath = entitiesProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplEntitiesPom(), (String)entitiesPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(entitiesProjectPath + "/" + GITIGNORE_FILENAME));
        String initProjectPath = GeneratorExtensions.getInitProjectPath(generationData);
        String initSrcMainResourcesPath = initProjectPath + "/" + "src/main/resources";
        String initSrcTestResourcesPath = initProjectPath + "/" + "src/test/resources";
        String initPomClassPath = initProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplInitPom(), (String)initPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(initProjectPath + "/" + GITIGNORE_FILENAME));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplLog4jProperties(), (String)(initSrcMainResourcesPath + "/" + LOG4J_PROPERTIES_FILENAME));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplH2ApplicationContextXml(), (String)(initSrcTestResourcesPath + "/test-h2-applicationContext.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplApplicationContextXml(), (String)(initSrcTestResourcesPath + "/test-applicationContext.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplTestNgXml(), (String)(initSrcTestResourcesPath + "/testng.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplPersistenceH2Xml(), (String)(initSrcMainResourcesPath + "/META-INF/persistence-h2.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplPersistenceXml(), (String)(initSrcMainResourcesPath + "/META-INF/persistence.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplJdbcH2Properties(), (String)(initSrcMainResourcesPath + "/jdbc-h2.properties"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplJdbcProperties(), (String)(initSrcMainResourcesPath + "/jdbc.properties"));
        String restApiProjectPath = GeneratorExtensions.getRestApiProjectPath(generationData);
        String restApiPomClassPath = restApiProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplRestApiPom(), (String)restApiPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(restApiProjectPath + "/" + GITIGNORE_FILENAME));
        String restClientProjectPath = GeneratorExtensions.getRestClientProjectPath(generationData);
        String restClientPomClassPath = restClientProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplRestClientPom(), (String)restClientPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(restClientProjectPath + "/" + GITIGNORE_FILENAME));
        String restWebProjectPath = GeneratorExtensions.getRestWebProjectPath(generationData);
        String restWebSrcMainResourcesPath = restWebProjectPath + "/" + "src/main/resources";
        String restWebSrcMainWebappPath = restWebProjectPath + "/" + SOURCE_FOLDER_SRC_MAIN_WEBAPP;
        String restWebPomClassPath = restWebProjectPath + "/" + POM_XML_FILENAME;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplRestWebPom(), (String)restWebPomClassPath);
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplGitignore(), (String)(restWebProjectPath + "/" + GITIGNORE_FILENAME));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplLog4jProperties(), (String)(restWebSrcMainResourcesPath + "/" + LOG4J_PROPERTIES_FILENAME));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplPersistenceH2Xml(), (String)(restWebSrcMainResourcesPath + "/META-INF/persistence-h2.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplPersistenceXml(), (String)(restWebSrcMainResourcesPath + "/META-INF/persistence.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplJdbcH2Properties(), (String)(restWebSrcMainResourcesPath + "/jdbc-h2.properties"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplJdbcProperties(), (String)(restWebSrcMainResourcesPath + "/jdbc.properties"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplDataApplicationContextXml(), (String)(restWebSrcMainResourcesPath + "/data-application-context.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplIndexJsp(), (String)(restWebSrcMainWebappPath + "/index.jsp"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplManifestMf(), (String)(restWebSrcMainWebappPath + "/META-INF/MANIFEST.MF"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplProjectProperties(), (String)(restWebSrcMainResourcesPath + "/project.properties"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplWebApplicationContextXml(), (String)(restWebSrcMainResourcesPath + "/web-application-context.xml"));
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplWebXml(), (String)(restWebSrcMainWebappPath + "/WEB-INF/web.xml"));
        String initializeDatabaseClassPath = GeneratorExtensions.getClassGenerationModelBean().getSrcFolder() + DB_INIT_PATH + INITIALIZE_DATABASE_CLASSNAME + FileExtension.JAVA.getExtension();
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplInitInitDbClass(), (String)(initProjectPath + "/" + initializeDatabaseClassPath));
        String basePackageName = GeneratorExtensions.getClassGenerationModelBean().getBasePackageName().replace(".", "/") + "/";
        String databaseInitializationClassPath = GeneratorExtensions.getClassGenerationModelBean().getSrcFolder() + basePackageName + DATABASE_INITIALIZATION_CLASSNAME + FileExtension.JAVA.getExtension();
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplInitDbInitClass(), (String)(initProjectPath + "/" + databaseInitializationClassPath));
        String applicationJettyRunnerClassPath = GeneratorExtensions.getClassGenerationModelBean().getSrcTestFolder() + basePackageName + "ApplicationJettyRunner" + FileExtension.JAVA.getExtension();
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)GeneratorExtensions.getVelocityTemplates().getTmplJettyRunnerClass(), (String)(restWebProjectPath + "/" + applicationJettyRunnerClassPath));
        if (withClasses) {
            ClassGenerationModelBean classGenerationModelBean = ClassGenerationModelBean.builder().basePackageName(generationData.getBasePackageName()).build();
            GeneratorExtensions.initWithdefaultValues(classGenerationModelBean);
            GeneratorExtensions.generateRepositoryClasses(classGenerationModelBean, generationData, true);
        }
    }

    public static void generateRepositoryClasses(boolean withProjectPath) throws Exception {
        ClassGenerationModelBean classGenerationModelBean = GeneratorExtensions.getClassGenerationModelBean();
        PomGenerationModelBean pomGenerationModelBean = GeneratorExtensions.getPomGenerationModelBean();
        GeneratorExtensions.generateRepositoryClasses(classGenerationModelBean, pomGenerationModelBean, withProjectPath);
    }

    public static void generateRepositoryClasses(ClassGenerationModelBean classGenerationModelBean, PomGenerationModelBean pomGenerationModelBean, boolean withProjectPath) throws Exception, IOException {
        GeneratorExtensions.initializeQualifiedModelClassNames(classGenerationModelBean);
        List<RepositoryClassModelBean> repositoryModels = GeneratorExtensions.getRepositoryClassModels(classGenerationModelBean);
        GeneratorExtensions.generateClasses(classGenerationModelBean, repositoryModels, pomGenerationModelBean, withProjectPath);
    }

    private static String getBusinessProjectPath(PomGenerationModelBean generationData) {
        String businessPomClassPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + "-business";
        return businessPomClassPath;
    }

    private static ClassGenerationModelBean getClassGenerationModelBean() {
        if (classGenerationData == null) {
            String classGenerationModel = "ClassGenerationModelBean.xml";
            classGenerationData = GeneratorExtensions.loadClassGenerationModelBean("ClassGenerationModelBean.xml");
        }
        return classGenerationData;
    }

    private static String getDomainProjectPath(PomGenerationModelBean generationData) {
        String domainPomClassPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + "-domain";
        return domainPomClassPath;
    }

    private static String getEntitiesProjectPath(PomGenerationModelBean generationData) {
        String projectPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + ENTITIES;
        return projectPath;
    }

    private static String getInitProjectPath(PomGenerationModelBean generationData) {
        String projectPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + INIT;
        return projectPath;
    }

    private static String getParentProjectPath(PomGenerationModelBean generationData) {
        return GeneratorExtensions.getParentProjectPath(generationData, generationData.getAbsoluteProjectPath());
    }

    private static String getParentProjectPath(PomGenerationModelBean generationData, String basePath) {
        String projectPath = generationData.getParentName();
        if (StringUtils.isNotEmpty((CharSequence)basePath)) {
            return basePath + "/" + projectPath;
        }
        return projectPath;
    }

    private static PomGenerationModelBean getPomGenerationModelBean() {
        if (pomGenerationData == null) {
            String pomGenerationModel = "PomGenerationModelBean.xml";
            pomGenerationData = GeneratorExtensions.loadPomGenerationModelBean("PomGenerationModelBean.xml");
        }
        return pomGenerationData;
    }

    private static VelocityTemplatesModelBean getVelocityTemplates() {
        if (templates == null) {
            String velocityTemplatesModelBean = "VelocityTemplatesModelBean.xml";
            templates = (VelocityTemplatesModelBean)XmlExtensions.loadObject((String)"VelocityTemplatesModelBean.xml");
        }
        return templates;
    }

    public static List<RepositoryClassModelBean> getRepositoryClassModels(ClassGenerationModelBean generator) {
        ArrayList<RepositoryClassModelBean> repositoryModels = new ArrayList<RepositoryClassModelBean>();
        for (String clazz : generator.getQualifiedModelClassNames()) {
            RepositoryClassModelBean model = new RepositoryClassModelBean();
            String modelClassName = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
            String domainClassName = modelClassName.substring(0, modelClassName.length() - 1);
            if (modelClassName.equals("package-info")) continue;
            try {
                Class<?> modelClass = Class.forName(clazz);
                Class primaryKeyClassType = TypeArgumentsExtensions.getFirstTypeArgument((Class)ClassExtensions.getBaseClass(modelClass), modelClass);
                String className = primaryKeyClassType.getName();
                model.setPrimaryKeyClassName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage() + "\n by get the first type argument from the entity class " + modelClassName);
            }
            repositoryModels.add(model);
            if (StringUtils.isNotEmpty((CharSequence)generator.getServicePackageName())) {
                model.setServicePackageName(generator.getServicePackageName());
            } else {
                model.setServicePackageName(generator.getBasePackageName() + ".service");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getDomainServicePackageName())) {
                model.setDomainServicePackageName(generator.getDomainServicePackageName());
            } else {
                model.setDomainServicePackageName(generator.getBasePackageName() + ".domain.service");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getModelPackageName())) {
                String modelPackageName = generator.getModelPackageName();
                model.setModelPackageName(modelPackageName);
            } else {
                model.setModelPackageName(generator.getBasePackageName() + ".entities");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getRepositoryPackageName())) {
                model.setRepositoryPackageName(generator.getRepositoryPackageName());
            } else {
                model.setRepositoryPackageName(generator.getBasePackageName() + ".repositories");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getDomainPackageName())) {
                model.setDomainPackageName(generator.getDomainPackageName());
            } else {
                model.setDomainPackageName(generator.getBasePackageName() + ".domain");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getDomainMapperPackageName())) {
                model.setDomainMapperPackageName(generator.getDomainMapperPackageName());
            } else {
                model.setDomainMapperPackageName(generator.getBasePackageName() + ".domain.mapper");
            }
            if (StringUtils.isNotEmpty((CharSequence)generator.getRestPackageName())) {
                model.setRestPackageName(generator.getRestPackageName());
            } else {
                model.setRestPackageName(generator.getBasePackageName() + ".rest");
            }
            String repositoryClassName = modelClassName + "Repository";
            String serviceInterfaceName = modelClassName + "Service";
            String repSpringRefClassName = StringExtensions.firstCharacterToLowerCase((String)repositoryClassName);
            String repServiceClassName = StringExtensions.firstCharacterToLowerCase((String)serviceInterfaceName);
            model.setServiceClassName(serviceInterfaceName);
            model.setRepServiceClassName(repServiceClassName);
            model.setModelQuilifiedClassName(clazz);
            model.setRepSpringRefClassName(repSpringRefClassName);
            model.setRepositoryClassName(repositoryClassName);
            model.setModelClassName(modelClassName);
            model.setModelInstanceName(StringExtensions.firstCharacterToLowerCase((String)model.getModelClassName()));
            model.setDomainClassName(domainClassName);
            String domainServiceInterfaceName = domainClassName + "Service";
            String repDomainServiceClassName = StringExtensions.firstCharacterToLowerCase((String)domainServiceInterfaceName);
            model.setRepDomainServiceClassName(repDomainServiceClassName);
            model.setDomainServiceClassName(domainServiceInterfaceName);
        }
        return repositoryModels;
    }

    private static String getRestApiProjectPath(PomGenerationModelBean generationData) {
        String projectPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + REST_API;
        return projectPath;
    }

    private static String getRestClientProjectPath(PomGenerationModelBean generationData) {
        String projectPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + REST_CLIENT;
        return projectPath;
    }

    private static String getRestWebProjectPath(PomGenerationModelBean generationData) {
        String projectPath = GeneratorExtensions.getParentProjectPath(generationData) + "/" + generationData.getParentName() + REST_WEB;
        return projectPath;
    }

    public static void initializeQualifiedModelClassNames(ClassGenerationModelBean generationData) throws Exception {
        if (StringUtils.isEmpty((CharSequence)generationData.getModelPackageName())) {
            generationData.setModelPackageName(generationData.getBasePackageName() + ".entities");
        }
        Set qualifiedModelClassNames = PackageExtensions.scanClassNames((String)generationData.getModelPackageName());
        generationData.setQualifiedModelClassNames(qualifiedModelClassNames);
    }

    public static ClassGenerationModelBean loadClassGenerationModelBean(String classGenerationModel) {
        ClassGenerationModelBean generator = (ClassGenerationModelBean)XmlExtensions.loadObject((String)classGenerationModel);
        GeneratorExtensions.initWithdefaultValues(generator);
        return generator;
    }

    public static void initWithdefaultValues(ClassGenerationModelBean generator) {
        String basePackageName = generator.getBasePackageName();
        String basePackagePath = PackageExtensions.getPackagePath((String)basePackageName);
        if (StringUtils.isEmpty((CharSequence)generator.getServicePackageName())) {
            generator.setServicePackageName(basePackageName + ".service");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getDomainServicePackageName())) {
            generator.setDomainServicePackageName(basePackageName + ".domain.service");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getModelPackageName())) {
            generator.setModelPackageName(basePackageName + ".entities");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getRepositoryPackageName())) {
            generator.setRepositoryPackageName(basePackageName + ".repositories");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getDomainPackageName())) {
            generator.setDomainPackageName(basePackageName + ".domain");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getDomainMapperPackageName())) {
            generator.setDomainMapperPackageName(basePackageName + ".domain.mapper");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getRestPackageName())) {
            generator.setRestPackageName(basePackageName + ".rest");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcFolder())) {
            generator.setSrcFolder("src/main/java/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcTestFolder())) {
            generator.setSrcTestFolder("src/test/java/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcGenerationPackage())) {
            generator.setSrcGenerationPackage(basePackagePath + "/repositories/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcRestGenerationPackage())) {
            generator.setSrcRestGenerationPackage(basePackagePath + "/rest/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcTestGenerationPackage())) {
            generator.setSrcTestGenerationPackage(basePackagePath + "/repositories/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcServiceGenerationPackage())) {
            generator.setSrcServiceGenerationPackage(basePackagePath + "/service/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcDomainGenerationPackage())) {
            generator.setSrcDomainGenerationPackage(basePackagePath + "/domain/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcDomainMapperGenerationPackage())) {
            generator.setSrcDomainMapperGenerationPackage(basePackagePath + "/mapper/");
        }
        if (StringUtils.isEmpty((CharSequence)generator.getSrcDomainServiceGenerationPackage())) {
            generator.setSrcDomainServiceGenerationPackage(basePackagePath + "/domain/service/");
        }
    }

    public static PomGenerationModelBean loadPomGenerationModelBean(String pomGenerationBean) {
        PomGenerationModelBean pomGeneration = (PomGenerationModelBean)XmlExtensions.loadObject((String)pomGenerationBean);
        if (StringUtils.isEmpty((CharSequence)pomGeneration.getAbsoluteProjectPath())) {
            pomGeneration.setAbsoluteProjectPath(".");
        }
        return pomGeneration;
    }

    private static void mergeProjectFile(VelocityContext context, String templateFileName, String projectPath, String generatedFilePath, boolean withProjectPath) throws IOException {
        String fileName = withProjectPath ? projectPath + "/" + generatedFilePath : generatedFilePath;
        VelocityExtensions.mergeToContext((VelocityContext)context, (String)templateFileName, (String)fileName);
    }

    private GeneratorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

