/**
 * Copyright (C) 2015 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.gen.src.model;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@EqualsAndHashCode
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class RepositoryClassModelBean implements Serializable
{

	private static final long serialVersionUID = 1L;

	private String domainClassName;

	private String domainMapperPackageName;

	private String domainPackageName;

	private String domainServiceClassName;

	private String domainServicePackageName;

	private String modelClassName;

	private String modelInstanceName;

	private String modelPackageName;

	private String modelQuilifiedClassName;

	private String primaryKeyClassName;

	private String repDomainServiceClassName;

	private String repositoryClassName;

	private String repositoryPackageName;

	private String repServiceClassName;

	private String repSpringRefClassName;

	private String restPackageName;

	private String serviceClassName;

	private String servicePackageName;

}
