/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.write;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class WriteFileExtensions {
    public static void write(InputStream inputStream, OutputStream outputStream) throws FileNotFoundException, IOException {
        int counter;
        byte[] byteArray = new byte[8192];
        while ((counter = inputStream.read(byteArray)) != -1) {
            outputStream.write(byteArray, 0, counter);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byteArray) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(byteArray);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    public static void writeByteArrayToFile(String filename, byte[] byteArray) throws IOException {
        File file = new File(filename);
        WriteFileExtensions.writeByteArrayToFile(file, byteArray);
    }

    private WriteFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

