/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.zip.ZipErrorCodes;
import de.alpharogroup.file.zip.ZipExtensions;
import de.alpharogroup.file.zip.ZipModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zipper
implements ZipModel {
    private static final Logger log = Logger.getLogger(Zipper.class.getName());
    private int compressionMethod = -1;
    private File directoryToZip;
    private String dirToStart;
    private int fileCounter = 0;
    private FilenameFilter fileFilter;
    private long fileLength = 0L;
    private File zipFile;
    private String zipFileComment;
    private String zipFileName;
    private ZipFile zipFileObj;
    private int zipLevel = -1;

    public static ZipperBuilder builder() {
        return new ZipperBuilder();
    }

    public Zipper() {
    }

    public Zipper(File dirToZip, File zipFile) {
        this(dirToZip, zipFile, null);
    }

    public Zipper(File dirToZip, File zipFile, FilenameFilter filter) {
        this.directoryToZip = dirToZip;
        this.zipFile = zipFile;
        this.setFileFilter(filter);
    }

    public Zipper(int compressionMethod, File directoryToZip, String dirToStart, int fileCounter, FilenameFilter fileFilter, long fileLength, File zipFile, String zipFileComment, String zipFileName, ZipFile zipFileObj, int zipLevel) {
        this.compressionMethod = compressionMethod;
        this.directoryToZip = directoryToZip;
        this.dirToStart = dirToStart;
        this.fileCounter = fileCounter;
        this.fileFilter = fileFilter;
        this.fileLength = fileLength;
        this.zipFile = zipFile;
        this.zipFileComment = zipFileComment;
        this.zipFileName = zipFileName;
        this.zipFileObj = zipFileObj;
        this.zipLevel = zipLevel;
    }

    @Override
    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    @Override
    public File getDirectoryToZip() {
        return this.directoryToZip;
    }

    @Override
    public String getDirToStart() {
        return this.dirToStart;
    }

    @Override
    public int getFileCounter() {
        return this.fileCounter;
    }

    @Override
    public FilenameFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public long getFileLength() {
        return this.fileLength;
    }

    @Override
    public File getZipFile() {
        return this.zipFile;
    }

    @Override
    public String getZipFileComment() {
        return this.zipFileComment;
    }

    @Override
    public String getZipFileName() {
        return this.zipFileName;
    }

    @Override
    public ZipFile getZipFileObj() {
        return this.zipFileObj;
    }

    @Override
    public int getZipLevel() {
        return this.zipLevel;
    }

    @Override
    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    @Override
    public void setDirectoryToZip(File directoryToZip) {
        this.directoryToZip = directoryToZip;
    }

    @Override
    public void setDirToStart(String dirToStart) {
        this.dirToStart = dirToStart;
    }

    @Override
    public void setFileCounter(int fileCounter) {
        this.fileCounter = fileCounter;
    }

    @Override
    public void setFileFilter(FilenameFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    @Override
    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void setZipFileComment(String zipFileComment) {
        this.zipFileComment = zipFileComment;
    }

    @Override
    public void setZipFileName(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    @Override
    public void setZipFileObj(ZipFile zipFileObj) {
        this.zipFileObj = zipFileObj;
    }

    @Override
    public void setZipLevel(int zipLevel) {
        this.zipLevel = zipLevel;
    }

    public ZipperBuilder toBuilder() {
        return new ZipperBuilder().compressionMethod(this.compressionMethod).directoryToZip(this.directoryToZip).dirToStart(this.dirToStart).fileCounter(this.fileCounter).fileFilter(this.fileFilter).fileLength(this.fileLength).zipFile(this.zipFile).zipFileComment(this.zipFileComment).zipFileName(this.zipFileName).zipFileObj(this.zipFileObj).zipLevel(this.zipLevel);
    }

    public String toString() {
        return "Zipper(compressionMethod=" + this.getCompressionMethod() + ", directoryToZip=" + this.getDirectoryToZip() + ", dirToStart=" + this.getDirToStart() + ", fileCounter=" + this.getFileCounter() + ", fileFilter=" + this.getFileFilter() + ", fileLength=" + this.getFileLength() + ", zipFile=" + this.getZipFile() + ", zipFileComment=" + this.getZipFileComment() + ", zipFileName=" + this.getZipFileName() + ", zipFileObj=" + this.getZipFileObj() + ", zipLevel=" + this.getZipLevel() + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ZipErrorCodes> zip() {
        try (FileOutputStream fos = new FileOutputStream(this.zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (!this.directoryToZip.exists()) {
                Optional<ZipErrorCodes> optional = Optional.of(ZipErrorCodes.DIRECTORY_TO_ZIP_DOES_NOT_EXIST);
                return optional;
            }
            if (!this.zipFile.exists()) {
                Optional<ZipErrorCodes> optional = Optional.of(ZipErrorCodes.ZIP_FILE_DOES_NOT_EXIST);
                return optional;
            }
            if (0 < this.zipLevel) {
                zos.setLevel(this.zipLevel);
            } else {
                zos.setLevel(9);
            }
            if (null != this.zipFileComment) {
                zos.setComment(this.zipFileComment);
            }
            if (0 < this.compressionMethod) {
                zos.setMethod(this.compressionMethod);
            }
            this.zipFiles(this.directoryToZip, zos);
            zos.flush();
            zos.finish();
            fos.flush();
            return Optional.empty();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return Optional.of(ZipErrorCodes.IO_ERROR);
        }
    }

    private void zipFiles(File file, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            List<File> foundedFiles = null != this.fileFilter ? ZipExtensions.getFoundedFiles(file, file.listFiles(this.fileFilter)) : Arrays.asList(file.listFiles());
            for (File foundedFile : foundedFiles) {
                this.zipFiles(foundedFile, zos);
            }
        } else {
            this.fileLength += file.length();
            ++this.fileCounter;
            String absolutePath = file.getAbsolutePath();
            if (this.dirToStart == null) {
                this.dirToStart = this.directoryToZip.getName();
            }
            int index = absolutePath.indexOf(this.dirToStart);
            String zipEntryName = absolutePath.substring(index, absolutePath.length());
            byte[] b = new byte[(int)file.length()];
            ZipEntry cpZipEntry = new ZipEntry(zipEntryName);
            zos.putNextEntry(cpZipEntry);
            zos.write(b, 0, (int)file.length());
            zos.closeEntry();
        }
    }

    public static class ZipperBuilder {
        private int compressionMethod;
        private File directoryToZip;
        private String dirToStart;
        private int fileCounter;
        private FilenameFilter fileFilter;
        private long fileLength;
        private File zipFile;
        private String zipFileComment;
        private String zipFileName;
        private ZipFile zipFileObj;
        private int zipLevel;

        ZipperBuilder() {
        }

        public Zipper build() {
            return new Zipper(this.compressionMethod, this.directoryToZip, this.dirToStart, this.fileCounter, this.fileFilter, this.fileLength, this.zipFile, this.zipFileComment, this.zipFileName, this.zipFileObj, this.zipLevel);
        }

        public ZipperBuilder compressionMethod(int compressionMethod) {
            this.compressionMethod = compressionMethod;
            return this;
        }

        public ZipperBuilder directoryToZip(File directoryToZip) {
            this.directoryToZip = directoryToZip;
            return this;
        }

        public ZipperBuilder dirToStart(String dirToStart) {
            this.dirToStart = dirToStart;
            return this;
        }

        public ZipperBuilder fileCounter(int fileCounter) {
            this.fileCounter = fileCounter;
            return this;
        }

        public ZipperBuilder fileFilter(FilenameFilter fileFilter) {
            this.fileFilter = fileFilter;
            return this;
        }

        public ZipperBuilder fileLength(long fileLength) {
            this.fileLength = fileLength;
            return this;
        }

        public String toString() {
            return "Zipper.ZipperBuilder(compressionMethod=" + this.compressionMethod + ", directoryToZip=" + this.directoryToZip + ", dirToStart=" + this.dirToStart + ", fileCounter=" + this.fileCounter + ", fileFilter=" + this.fileFilter + ", fileLength=" + this.fileLength + ", zipFile=" + this.zipFile + ", zipFileComment=" + this.zipFileComment + ", zipFileName=" + this.zipFileName + ", zipFileObj=" + this.zipFileObj + ", zipLevel=" + this.zipLevel + ")";
        }

        public ZipperBuilder zipFile(File zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        public ZipperBuilder zipFileComment(String zipFileComment) {
            this.zipFileComment = zipFileComment;
            return this;
        }

        public ZipperBuilder zipFileName(String zipFileName) {
            this.zipFileName = zipFileName;
            return this;
        }

        public ZipperBuilder zipFileObj(ZipFile zipFileObj) {
            this.zipFileObj = zipFileObj;
            return this;
        }

        public ZipperBuilder zipLevel(int zipLevel) {
            this.zipLevel = zipLevel;
            return this;
        }
    }
}

