/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.rename;

import de.alpharogroup.file.FileExtensions;
import de.alpharogroup.file.copy.CopyFileExtensions;
import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.file.exceptions.FileDoesNotExistException;
import de.alpharogroup.file.exceptions.FileIsADirectoryException;
import de.alpharogroup.file.exceptions.FileNotRenamedException;
import de.alpharogroup.file.search.FileSearchExtensions;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class RenameFileExtensions {
    public static String appendSystemtimeToFilename(File fileToRename) {
        return RenameFileExtensions.appendSystemtimeToFilename(fileToRename, null);
    }

    public static String appendSystemtimeToFilename(File fileToRename, Date add2Name) {
        SimpleDateFormat df;
        String format = "HHmmssSSS";
        String sysTime = null;
        if (null != add2Name) {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(add2Name);
        } else {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(new Date());
        }
        String fileName = fileToRename.getName();
        int ext_index = fileName.lastIndexOf(".");
        String ext = fileName.substring(ext_index, fileName.length());
        String newName = fileName.substring(0, ext_index);
        newName = newName + "_" + sysTime + ext;
        return newName;
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        return RenameFileExtensions.changeAllFilenameSuffix(file, oldSuffix, newSuffix, false);
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        ArrayList<File> notDeletedFiles = null;
        String filePath = file.getAbsolutePath();
        String[] suffix = new String[]{oldSuffix};
        List<File> files = FileSearchExtensions.findFiles(filePath, suffix);
        int fileCount = files.size();
        for (int i = 0; i < fileCount; ++i) {
            File currentFile = files.get(i);
            boolean success = RenameFileExtensions.changeFilenameSuffix(currentFile, newSuffix, delete);
            if (success) continue;
            if (null != notDeletedFiles) {
                notDeletedFiles.add(currentFile);
                continue;
            }
            notDeletedFiles = new ArrayList<File>();
            notDeletedFiles.add(currentFile);
        }
        return notDeletedFiles;
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix) throws FileNotRenamedException, FileDoesNotExistException, IOException, FileIsADirectoryException {
        return RenameFileExtensions.changeFilenameSuffix(file, newSuffix, false);
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        if (!file.exists()) {
            String error = "The " + file + " does not exists.";
            throw new FileDoesNotExistException(error);
        }
        String fileNamePrefix = FileExtensions.getFilenamePrefix(file);
        String newFilename = fileNamePrefix + newSuffix;
        File file2 = new File(newFilename);
        boolean success = RenameFileExtensions.renameFile(file, file2, delete);
        return success;
    }

    public static boolean forceToMoveFile(File srcFile, File destinationFile) throws IOException, FileIsADirectoryException {
        boolean moved = RenameFileExtensions.renameFile(srcFile, destinationFile, true);
        return moved;
    }

    public static boolean moveFile(File srcFile, File destDir) throws IOException, FileIsADirectoryException {
        return RenameFileExtensions.renameFile(srcFile, destDir, true);
    }

    public static boolean renameFile(File fileToRename, File newFileName) throws IOException, FileIsADirectoryException {
        return RenameFileExtensions.renameFile(fileToRename, newFileName, false);
    }

    public static boolean renameFile(File fileToRename, File newFileName, boolean delete) throws IOException, FileIsADirectoryException {
        boolean success = fileToRename.renameTo(newFileName);
        if (!success && delete) {
            CopyFileExtensions.copyFile(fileToRename, newFileName);
            DeleteFileExtensions.delete(fileToRename);
            success = true;
        }
        return success;
    }

    public static boolean renameFile(File fileToRename, String newFileNameWithoutAbsolutPath) throws IOException, FileIsADirectoryException, FileDoesNotExistException {
        if (!fileToRename.exists()) {
            throw new FileDoesNotExistException("File" + fileToRename.getName() + " does not exists!");
        }
        String fileNameAbsolutPathPrefix = FileExtensions.getAbsolutPathWithoutFilename(fileToRename);
        StringBuffer sb = new StringBuffer();
        sb.append(fileNameAbsolutPathPrefix);
        sb.append(newFileNameWithoutAbsolutPath);
        File newNameForFile = new File(sb.toString());
        boolean sucess = RenameFileExtensions.renameFile(fileToRename, newNameForFile);
        return sucess;
    }

    public static File renameFileWithSystemtime(File fileToRename) throws IOException, FileIsADirectoryException {
        String newFilenameWithSystemtime = RenameFileExtensions.appendSystemtimeToFilename(fileToRename);
        File fileWithNewName = new File(fileToRename.getParent(), newFilenameWithSystemtime);
        RenameFileExtensions.renameFile(fileToRename, fileWithNewName, true);
        return fileWithNewName;
    }

    private RenameFileExtensions() {
    }
}

