/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.read;

import de.alpharogroup.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class ReadFileExtensions {
    public static Byte[] getFilecontentAsByteObjectArray(File tmpFile) throws IOException {
        return ReadFileExtensions.toObject(ReadFileExtensions.toByteArray(tmpFile));
    }

    public static String inputStream2String(InputStream inputStream) throws IOException {
        return ReadFileExtensions.inputStream2String(inputStream, Charset.forName("UTF-8"));
    }

    public static String inputStream2String(InputStream inputStream, Charset encoding) throws IOException {
        return ReadFileExtensions.reader2String(new InputStreamReader(inputStream, encoding));
    }

    public static Reader openFileReader(String fileName) throws IOException {
        BufferedReader bufferedReader = null;
        File file = new File(fileName);
        bufferedReader = (BufferedReader)StreamExtensions.getReader((File)file);
        return bufferedReader;
    }

    public static String reader2String(Reader reader) throws IOException {
        int tmp;
        StringBuffer stringBuffer = new StringBuffer();
        char[] charArray = new char[8192];
        while ((tmp = reader.read(charArray)) > 0) {
            stringBuffer.append(charArray, 0, tmp);
        }
        return stringBuffer.toString();
    }

    public static byte[] readFileToBytearray(File file) throws IOException {
        return ReadFileExtensions.toByteArray(file);
    }

    public static String readFromFile(File file) throws IOException {
        return ReadFileExtensions.inputStream2String(StreamExtensions.getInputStream((File)file));
    }

    public static String readFromFile(File file, Charset encoding) throws IOException {
        return ReadFileExtensions.inputStream2String(StreamExtensions.getInputStream((File)file), encoding);
    }

    public static String readHeadLine(String inputFile) throws FileNotFoundException, IOException {
        String headLine = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
            headLine = reader.readLine();
        }
        return headLine;
    }

    public static List<String> readLinesInList(File input) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static List<String> readLinesInList(File input, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), trim);
    }

    public static List<String> readLinesInList(File input, Charset encoding) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, encoding, false);
    }

    public static List<String> readLinesInList(File input, Charset encoding, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), encoding, trim);
    }

    public static List<String> readLinesInList(InputStream input) throws IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static List<String> readLinesInList(InputStream input, boolean trim) throws IOException {
        return ReadFileExtensions.readLinesInList(input, Charset.forName("UTF-8"), trim);
    }

    public static List<String> readLinesInList(InputStream input, Charset encoding, boolean trim) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (InputStreamReader isr = encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding);
             BufferedReader reader = new BufferedReader(isr);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (trim) {
                    line.trim();
                }
                output.add(line);
            }
        }
        return output;
    }

    public static Properties readPropertiesFromFile(String filename) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(filename);){
            properties.load(fis);
        }
        return properties;
    }

    public static byte[] toByteArray(File tmpFile) throws IOException {
        byte[] data = null;
        if (tmpFile.exists() && !tmpFile.isDirectory()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(tmpFile));
                 ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
                StreamExtensions.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos);
                data = bos.toByteArray();
            }
        }
        return data;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    private static Byte[] toObject(byte[] byteArray) {
        return ArrayUtils.toObject((byte[])byteArray);
    }

    private ReadFileExtensions() {
    }
}

