/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.search;

import de.alpharogroup.file.filter.MultiplyExtensionsFileFilter;
import de.alpharogroup.regex.RegExExtensions;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public final class FileSearchExtensions {
    public static boolean containsFile(File parent, File search) {
        boolean exists = false;
        String[] children = parent.list();
        if (children == null) {
            return false;
        }
        List<String> fileList = Arrays.asList(children);
        if (fileList.contains(search.getName())) {
            exists = true;
        }
        return exists;
    }

    public static boolean containsFile(File fileToSearch, String pathname) {
        String[] allFiles = fileToSearch.list();
        if (allFiles == null) {
            return false;
        }
        List<String> list = Arrays.asList(allFiles);
        return list.contains(pathname);
    }

    public static boolean containsFileRecursive(File parent, File search) {
        File toSearch = search.getAbsoluteFile();
        boolean exists = false;
        File[] children = parent.getAbsoluteFile().listFiles();
        if (children == null) {
            return false;
        }
        List<File> fileList = Arrays.asList(children);
        for (File currentFile : fileList) {
            if (currentFile.isDirectory() && (exists = FileSearchExtensions.containsFileRecursive(currentFile, toSearch))) {
                return true;
            }
            if (!fileList.contains(toSearch)) continue;
            return true;
        }
        return exists;
    }

    public static long countAllFilesInDirectory(File dir, long length, boolean includeDirectories) {
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return length;
        }
        for (File element : children) {
            if (element.isDirectory()) {
                if (includeDirectories) {
                    ++length;
                }
                length = FileSearchExtensions.countAllFilesInDirectory(element, length, includeDirectories);
                continue;
            }
            ++length;
        }
        return length;
    }

    public static List<File> findAllFiles(File dir, String fileSearchPattern) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundFiles;
        }
        for (File element : children) {
            if (element.isDirectory()) {
                List<File> foundedFiles = FileSearchExtensions.findAllFiles(element, fileSearchPattern);
                foundFiles.addAll(foundedFiles);
                continue;
            }
            String filename = element.getName();
            if (!filename.matches(fileSearchPattern)) continue;
            foundFiles.add(element.getAbsoluteFile());
        }
        return foundFiles;
    }

    public static List<File> findFiles(File dir, String filenameToSearch) {
        String[] children;
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = RegExExtensions.replaceWildcardsWithRE((String)filenameToSearch);
        for (String filename : children = dir.list()) {
            if (!filename.matches(regex)) continue;
            File foundedFile = new File(filename);
            foundedFileList.add(foundedFile);
        }
        return foundedFileList;
    }

    public static List<File> findFiles(String start, String[] extensions) {
        ArrayList<File> files = new ArrayList<File>();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(start);
        if (startdir.isDirectory()) {
            dirs.push(new File(start));
        }
        while (dirs.size() > 0) {
            File dirFiles = (File)dirs.pop();
            String[] s = dirFiles.list();
            if (s == null) continue;
            for (String element : s) {
                File file = new File(dirFiles.getAbsolutePath() + File.separator + element);
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!FileSearchExtensions.match(element, extensions)) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static List<File> findFilesRecursive(File dir, String filenameToSearch) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = RegExExtensions.replaceWildcardsWithRE((String)filenameToSearch);
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File element : children) {
            if (element.isDirectory()) {
                List<File> foundedFiles = FileSearchExtensions.findFilesRecursive(element, filenameToSearch);
                foundedFileList.addAll(foundedFiles);
                continue;
            }
            String filename = element.getName();
            if (!filename.matches(regex)) continue;
            foundedFileList.add(element.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> findFilesWithFilter(File dir, String ... extension) {
        File[] children;
        ArrayList<File> foundedFileList = new ArrayList<File>();
        for (File element : children = dir.listFiles((FileFilter)new MultiplyExtensionsFileFilter(true, extension))) {
            if (element.isDirectory()) {
                foundedFileList.addAll(FileSearchExtensions.findFilesWithFilter(element, extension));
                continue;
            }
            foundedFileList.add(element.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> getAllFilesFromDir(File dir) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File child : children) {
            if (child.isDirectory()) continue;
            foundedFileList.add(child.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> getAllFilesFromDirRecursive(File dir) {
        return FileSearchExtensions.findFilesRecursive(dir, "*");
    }

    public static long getFileLengthInKilobytes(File dir) {
        long fileLength = dir.getTotalSpace();
        return fileLength / 1024L;
    }

    public static long getFileLengthInMegabytes(File dir) {
        return FileSearchExtensions.getFileLengthInKilobytes(dir) / 1024L;
    }

    public static String getSearchFilePattern(String ... fileExtensions) {
        if (fileExtensions.length == 0) {
            return "";
        }
        String searchFilePatternPrefix = "([^\\s]+(\\.(?i)(";
        String searchFilePatternSuffix = "))$)";
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (String fileExtension : fileExtensions) {
            if (count < fileExtensions.length) {
                sb.append(fileExtension).append("|");
            } else {
                sb.append(fileExtension);
            }
            ++count;
        }
        return "([^\\s]+(\\.(?i)(" + sb.toString().trim() + "))$)";
    }

    public static List<File> listDirs(File dir) {
        File[] fileArray;
        ArrayList<File> foundedDirs = new ArrayList<File>();
        for (File element : fileArray = dir.listFiles()) {
            if (!element.isDirectory()) continue;
            foundedDirs.add(element);
        }
        return foundedDirs;
    }

    public static boolean match(String stringToMatch, String[] suffixes) {
        for (String suffix : suffixes) {
            int suffixesLength = suffix.length();
            int stringToMatchLength = stringToMatch.length();
            int result = stringToMatchLength - suffixesLength;
            String extensionToMatch = stringToMatch.substring(result, stringToMatchLength);
            boolean equals = extensionToMatch.equalsIgnoreCase(suffix);
            if (stringToMatchLength < suffixesLength || !equals) continue;
            return true;
        }
        return false;
    }

    private FileSearchExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

