/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.create;

import de.alpharogroup.file.exceptions.DirectoryAllreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public final class CreateFileExtensions {
    public static boolean newDirectories(Collection<File> directories) throws DirectoryAllreadyExistsException {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileExtensions.newDirectory(dir);
        }
        return created;
    }

    public static boolean newDirectory(File dir) throws DirectoryAllreadyExistsException {
        boolean created = false;
        if (dir.exists()) {
            throw new DirectoryAllreadyExistsException("Directory allready exists.");
        }
        created = dir.mkdir();
        return created;
    }

    public static boolean newFile(File file) throws IOException {
        boolean created = false;
        if (!file.exists()) {
            CreateFileExtensions.newParentDirectories(file);
            created = file.createNewFile();
        } else {
            created = true;
        }
        return created;
    }

    public static boolean newFiles(Collection<File> files) throws IOException {
        boolean created = false;
        for (File file : files) {
            created = CreateFileExtensions.newFile(file);
        }
        return created;
    }

    public static void newParentDirectories(File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    private CreateFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

