/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file;

import java.util.ArrayList;
import java.util.List;

public final class GeneratorExtensions {
    public static List<String> newConstantsFromStringList(List<String> data, String prefix, String suffix, boolean withQuotation) {
        ArrayList<String> returnList = new ArrayList<String>();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            String element = data.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append("public static final String ");
            if (withQuotation) {
                String striped = element.trim().toUpperCase();
                striped = striped.substring(1, striped.length() - 1);
                if (null != prefix) {
                    sb.append(prefix.toUpperCase());
                }
                sb.append(striped);
                if (null != suffix) {
                    sb.append(suffix.toUpperCase());
                }
                sb.append(" = ");
                sb.append(element + ";");
            } else {
                if (null != prefix) {
                    sb.append(prefix.toUpperCase());
                }
                sb.append(element.trim().toUpperCase());
                if (null != suffix) {
                    sb.append(suffix.toUpperCase());
                }
                sb.append(" = ");
                sb.append("\"" + element + "\";");
            }
            returnList.add(sb.toString().trim());
        }
        return returnList;
    }

    public static String newStaticArrayVariable(String arrayName, List<String> data) {
        StringBuffer sb = new StringBuffer();
        sb.append("public static final String []");
        sb.append(arrayName.trim().toUpperCase());
        sb.append(" = {");
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            String element = data.get(i);
            if (i < size - 1) {
                sb.append("\"" + element + "\", ");
                continue;
            }
            sb.append("\"" + element + "\"");
        }
        sb.append("};");
        return sb.toString();
    }

    private GeneratorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

