/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.zip.ZipState;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public class ZipDecryptInputStream
extends InputStream {
    private static final int[] CRC_TABLE = new int[256];
    private static final int DECRYPT_HEADER_SIZE = 12;
    private static final int[] LFH_SIGNATURE = new int[]{80, 75, 3, 4};
    private int compressedSize;
    private final InputStream delegate;
    private final int[] keys = new int[3];
    private final String password;
    private int skipBytes;
    private ZipState state = ZipState.SIGNATURE;
    private int value;
    private int valueInc;
    private int valuePos;

    public ZipDecryptInputStream(InputStream stream, String password) {
        this.delegate = stream;
        this.password = password;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    private int crc32(int oldCrc, byte charAt) {
        return oldCrc >>> 8 ^ CRC_TABLE[(oldCrc ^ charAt) & 0xFF];
    }

    private byte decryptByte() {
        int temp = this.keys[2] | 2;
        return (byte)(temp * (temp ^ 1) >>> 8);
    }

    private void initKeys(String password) {
        this.keys[0] = 305419896;
        this.keys[1] = 591751049;
        this.keys[2] = 878082192;
        for (int i = 0; i < password.length(); ++i) {
            this.updateKeys((byte)(password.charAt(i) & 0xFF));
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.delegate.read();
        return this.readlocal(result);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.delegate.read(b, off, len);
        return this.readlocal(result);
    }

    private int readlocal(int result) throws IOException {
        if (this.skipBytes == 0) {
            switch (this.state) {
                case SIGNATURE: {
                    if (result != LFH_SIGNATURE[this.valuePos]) {
                        this.state = ZipState.TAIL;
                        break;
                    }
                    ++this.valuePos;
                    if (this.valuePos < LFH_SIGNATURE.length) break;
                    this.skipBytes = 2;
                    this.state = ZipState.FLAGS;
                    break;
                }
                case FLAGS: {
                    if ((result & 1) == 0) {
                        throw new IllegalStateException("ZIP not password protected.");
                    }
                    if ((result & 0x40) == 64) {
                        throw new IllegalStateException("Strong encryption used.");
                    }
                    if ((result & 8) == 8) {
                        throw new IllegalStateException("Unsupported ZIP format.");
                    }
                    --result;
                    this.compressedSize = 0;
                    this.valuePos = 0;
                    this.valueInc = 12;
                    this.state = ZipState.COMPRESSED_SIZE;
                    this.skipBytes = 11;
                    break;
                }
                case COMPRESSED_SIZE: {
                    this.compressedSize += result << 8 * this.valuePos;
                    if ((result -= this.valueInc) < 0) {
                        this.valueInc = 1;
                        result += 256;
                    } else {
                        this.valueInc = 0;
                    }
                    ++this.valuePos;
                    if (this.valuePos <= 3) break;
                    this.valuePos = 0;
                    this.value = 0;
                    this.state = ZipState.FN_LENGTH;
                    this.skipBytes = 4;
                    break;
                }
                case FN_LENGTH: 
                case EF_LENGTH: {
                    this.value += result << 8 * this.valuePos;
                    if (this.valuePos == 1) {
                        this.valuePos = 0;
                        if (this.state == ZipState.FN_LENGTH) {
                            this.state = ZipState.EF_LENGTH;
                            break;
                        }
                        this.state = ZipState.HEADER;
                        this.skipBytes = this.value;
                        break;
                    }
                    this.valuePos = 1;
                    break;
                }
                case HEADER: {
                    this.initKeys(this.password);
                    for (int i = 0; i < 12; ++i) {
                        this.updateKeys((byte)(result ^ this.decryptByte()));
                        result = this.delegate.read();
                    }
                    this.compressedSize -= 12;
                    this.state = ZipState.DATA;
                }
                case DATA: {
                    result = (result ^ this.decryptByte()) & 0xFF;
                    this.updateKeys((byte)result);
                    --this.compressedSize;
                    if (this.compressedSize != 0) break;
                    this.valuePos = 0;
                    this.state = ZipState.SIGNATURE;
                    break;
                }
            }
        } else {
            --this.skipBytes;
        }
        return result;
    }

    private void updateKeys(byte charAt) {
        this.keys[0] = this.crc32(this.keys[0], charAt);
        this.keys[1] = this.keys[1] + (this.keys[0] & 0xFF);
        this.keys[1] = this.keys[1] * 134775813 + 1;
        this.keys[2] = this.crc32(this.keys[2], (byte)(this.keys[1] >> 24));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int r = i;
            for (int j = 0; j < 8; ++j) {
                if ((r & 1) == 1) {
                    r = r >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r >>>= 1;
            }
            ZipDecryptInputStream.CRC_TABLE[i] = r;
        }
    }
}

