/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.write;

import de.alpharogroup.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class WriteFileExtensions {
    private static final Logger LOGGER = Logger.getLogger((String)WriteFileExtensions.class.getName());

    public static void readSourceFileAndWriteDestFile(String srcfile, String destFile) {
        try (FileInputStream fis = new FileInputStream(srcfile);
             FileOutputStream fos = new FileOutputStream(destFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int availableLength = bis.available();
            byte[] totalBytes = new byte[availableLength];
            bis.read(totalBytes, 0, availableLength);
            bos.write(totalBytes, 0, availableLength);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("readSourceFileAndWriteDestFile failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("readSourceFileAndWriteDestFile failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void storeByteArrayToFile(byte[] data, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(data);
            bos.flush();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("storeByteArrayToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("storeByteArrayToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static boolean string2File(File file, String string2write) {
        return WriteFileExtensions.writeStringToFile(file, string2write, null);
    }

    public static boolean string2File(File file, String string2write, String encoding) {
        return WriteFileExtensions.writeStringToFile(file, string2write, encoding);
    }

    public static void string2File(String string2write, String nameOfFile) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(nameOfFile));){
            bufferedWriter.write(string2write);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)("string2File failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws FileNotFoundException, IOException {
        int counter;
        byte[] byteArray = new byte[8192];
        while ((counter = inputStream.read(byteArray)) != -1) {
            outputStream.write(byteArray, 0, counter);
        }
    }

    public static void write2File(Reader reader, Writer writer, boolean closeStream) {
        WriteFileExtensions.write2File(reader, writer);
    }

    public static void write2File(Reader reader, Writer writer) {
        try {
            int byt;
            while ((byt = reader.read()) != -1) {
                writer.write(byt);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void write2File(String inputFile, String outputFile) {
        try (FileInputStream fis = new FileInputStream(inputFile);
             FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            StreamExtensions.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void write2File(String inputFile, Writer writer, boolean closeWriter) {
        WriteFileExtensions.write2File(inputFile, writer);
    }

    public static void write2File(String inputFile, Writer writer) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(inputFile));){
            WriteFileExtensions.write2File(bufferedReader, writer);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void write2FileWithBuffer(String inputFile, String outputFile) {
        try (InputStream inputStream = StreamExtensions.getInputStream((File)new File(inputFile));
             OutputStream outputStream = StreamExtensions.getOutputStream((File)new File(outputFile));){
            WriteFileExtensions.write(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("write2FileWithBuffer failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("write2FileWithBuffer failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byteArray) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(byteArray);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    public static void writeByteArrayToFile(String filename, byte[] byteArray) throws IOException {
        File file = new File(filename);
        WriteFileExtensions.writeByteArrayToFile(file, byteArray);
    }

    public static void writeLinesToFile(Collection<String> collection, File output) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileExtensions.string2File(output, sb.toString());
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileExtensions.string2File(output, sb.toString(), encoding);
    }

    public static void writeLinesToFile(File output, List<String> input, String encoding) {
        String lineSeparator = System.getProperty("line.separator");
        try (FileOutputStream fos = new FileOutputStream(output);
             OutputStreamWriter osw = null == encoding ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, encoding);
             PrintWriter out = new PrintWriter(osw);){
            int size = input.size();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                String entry = input.get(i);
                sb.append(entry).append(lineSeparator);
            }
            out.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("writeLinesToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("writeLinesToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("writeLinesToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void writeProperties2File(String filename, Properties properties) {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            properties.store(fos, null);
        }
        catch (IOException e) {
            LOGGER.error((Object)("writeProperties2File failed...\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static boolean writeStringToFile(File file, String string2write, String encoding) {
        boolean iswritten = true;
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             OutputStreamWriter osw = null == encoding ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
             PrintWriter printWriter = new PrintWriter(osw);){
            printWriter.write(string2write);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("writeStringToFile failed...\n" + e.getMessage()), (Throwable)e);
            iswritten = false;
        }
        catch (IOException e) {
            LOGGER.error((Object)("writeStringToFile failed...\n" + e.getMessage()), (Throwable)e);
        }
        return iswritten;
    }

    private WriteFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

