/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.rename;

import de.alpharogroup.file.FileExtensions;
import de.alpharogroup.file.copy.CopyFileExtensions;
import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.file.exceptions.FileDoesNotExistException;
import de.alpharogroup.file.exceptions.FileIsADirectoryException;
import de.alpharogroup.file.exceptions.FileNotRenamedException;
import de.alpharogroup.file.search.FileSearchExtensions;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenameFileExtensions {
    private static final Logger log = LoggerFactory.getLogger(RenameFileExtensions.class);

    public static String appendSystemtimeToFilename(File fileToRename) {
        return RenameFileExtensions.appendSystemtimeToFilename(fileToRename, null);
    }

    public static String appendSystemtimeToFilename(File fileToRename, Date add2Name) {
        SimpleDateFormat df;
        String format = "HHmmssSSS";
        String sysTime = null;
        if (null != add2Name) {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(add2Name);
        } else {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(new Date());
        }
        String fileName = fileToRename.getName();
        int ext_index = fileName.lastIndexOf(".");
        String ext = fileName.substring(ext_index, fileName.length());
        String newName = fileName.substring(0, ext_index);
        newName = newName + "_" + sysTime + ext;
        return newName;
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix) throws IOException, FileDoesNotExistException {
        return RenameFileExtensions.changeAllFilenameSuffix(file, oldSuffix, newSuffix, false);
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException {
        ArrayList<File> notDeletedFiles = null;
        String filePath = file.getAbsolutePath();
        String[] suffix = new String[]{oldSuffix};
        List<File> files = FileSearchExtensions.findFiles(filePath, suffix);
        int fileCount = files.size();
        for (int i = 0; i < fileCount; ++i) {
            boolean success;
            File currentFile = files.get(i);
            try {
                success = RenameFileExtensions.changeFilenameSuffix(currentFile, newSuffix, delete);
            }
            catch (FileDoesNotExistException e) {
                log.error("changeAllFilenameSuffix failed...\n" + e.getMessage(), (Throwable)e);
                success = false;
            }
            if (success) continue;
            if (null != notDeletedFiles) {
                notDeletedFiles.add(currentFile);
                continue;
            }
            notDeletedFiles = new ArrayList<File>();
            notDeletedFiles.add(currentFile);
        }
        return notDeletedFiles;
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix) throws FileNotRenamedException, FileDoesNotExistException, IOException {
        return RenameFileExtensions.changeFilenameSuffix(file, newSuffix, false);
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException {
        if (!file.exists()) {
            String error = "The " + file + " does not exists.";
            throw new FileDoesNotExistException(error);
        }
        String fileNamePrefix = FileExtensions.getFilenamePrefix(file);
        String newFilename = fileNamePrefix + newSuffix;
        File file2 = new File(newFilename);
        boolean success = RenameFileExtensions.renameFile(file, file2, delete);
        return success;
    }

    public static boolean forceToMoveFile(File srcFile, File destinationFile) {
        boolean moved = false;
        try {
            moved = RenameFileExtensions.renameFile(srcFile, destinationFile, true);
        }
        catch (Exception e) {
            log.error("forceToMoveFile method failed...\n" + e.getMessage(), (Throwable)e);
        }
        return moved;
    }

    public static String getAbsolutPathWithoutFilename(File file) {
        return FileExtensions.getAbsolutPathWithoutFilename(file);
    }

    public static boolean moveFile(File srcFile, File destDir) {
        return RenameFileExtensions.renameFile(srcFile, destDir, true);
    }

    public static boolean renameFile(File fileToRename, File newFileName) {
        return RenameFileExtensions.renameFile(fileToRename, newFileName, false);
    }

    public static boolean renameFile(File fileToRename, File newFileName, boolean delete) {
        boolean success = fileToRename.renameTo(newFileName);
        if (!success) {
            log.info("The file " + fileToRename.getName() + " was not renamed.");
            if (delete) {
                log.info("Try to copy the content into the new file with the new name.");
                try {
                    boolean copied = CopyFileExtensions.copyFile(fileToRename, newFileName);
                    if (copied) {
                        log.info("Sucessfully copied the old file " + fileToRename.getName() + " to the new file " + newFileName.getName() + ".");
                    } else {
                        log.info("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                    }
                }
                catch (IOException e) {
                    log.error("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                }
                catch (FileIsADirectoryException e) {
                    log.error("Given file " + newFileName.getName() + " is a directory.", (Throwable)e);
                }
                log.info("Try to delete the old file " + fileToRename.getName() + ".");
                try {
                    DeleteFileExtensions.delete(fileToRename);
                    success = true;
                }
                catch (IOException e) {
                    log.error("Try to delete the old file " + fileToRename.getName() + " failed.", (Throwable)e);
                }
            }
        }
        return success;
    }

    public static boolean renameFile(File fileToRename, String newFileNameWithoutAbsolutPath) {
        if (!fileToRename.exists()) {
            try {
                throw new FileDoesNotExistException("File" + fileToRename.getName() + " does not exists!");
            }
            catch (FileDoesNotExistException e) {
                e.printStackTrace();
                return false;
            }
        }
        String fileNameAbsolutPathPrefix = FileExtensions.getAbsolutPathWithoutFilename(fileToRename);
        StringBuffer sb = new StringBuffer();
        sb.append(fileNameAbsolutPathPrefix);
        sb.append(newFileNameWithoutAbsolutPath);
        File newNameForFile = new File(sb.toString());
        boolean sucess = RenameFileExtensions.renameFile(fileToRename, newNameForFile);
        return sucess;
    }

    public static File renameFileWithSystemtime(File fileToRename) {
        String newFilenameWithSystemtime = RenameFileExtensions.appendSystemtimeToFilename(fileToRename);
        File fileWithNewName = new File(fileToRename.getParent(), newFilenameWithSystemtime);
        RenameFileExtensions.renameFile(fileToRename, fileWithNewName, true);
        return fileWithNewName;
    }

    private RenameFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

