/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.compare;

import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumExtensions;
import de.alpharogroup.file.compare.CompareFileExtensions;
import java.io.File;
import java.security.NoSuchAlgorithmException;

public final class SimpleCompareFileExtensions {
    public static boolean compareFilesByAbsolutePath(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, false, true, true, true, true, true).getAbsolutePathEquality();
    }

    public static boolean compareFilesByChecksum(File sourceFile, File fileToCompare, Algorithm algorithm) throws NoSuchAlgorithmException {
        String checksumSourceFile = ChecksumExtensions.getChecksum(sourceFile, algorithm);
        String checksumFileToCompare = ChecksumExtensions.getChecksum(fileToCompare, algorithm);
        return checksumSourceFile.equals(checksumFileToCompare);
    }

    public static boolean compareFilesByChecksumAdler32(File sourceFile, File fileToCompare) {
        long checksumFileToCompare;
        long checksumSourceFile = ChecksumExtensions.getCheckSumAdler32(sourceFile);
        return checksumSourceFile == (checksumFileToCompare = ChecksumExtensions.getCheckSumAdler32(fileToCompare));
    }

    public static boolean compareFilesByChecksumCRC32(File sourceFile, File fileToCompare) {
        long checksumFileToCompare;
        long checksumSourceFile = ChecksumExtensions.getCheckSumCRC32(sourceFile);
        return checksumSourceFile == (checksumFileToCompare = ChecksumExtensions.getCheckSumCRC32(fileToCompare));
    }

    public static boolean compareFilesByContent(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, true, true, false).getContentEquality();
    }

    public static boolean compareFilesByExtension(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, false, true, true, true, true).getFileExtensionEquality();
    }

    public static boolean compareFilesByLastModified(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, false, true, true).getLastModifiedEquality();
    }

    public static boolean compareFilesByLength(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, false, true, true, true).getLengthEquality();
    }

    public static boolean compareFilesByName(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, true, false, true).getNameEquality();
    }

    private SimpleCompareFileExtensions() {
    }
}

