/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file;

import de.alpharogroup.file.FilenameExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.file.rename.RenameFileExtensions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileLock;
import org.apache.log4j.Logger;

public final class FileExtensions {
    public static final String VELOCITY_TEMPLATE_FILE_EXTENSION = ".vm";
    private static final Logger LOGGER = Logger.getLogger((String)FileExtensions.class.getName());

    public static byte[] download(URI uri) {
        File tmpFile = new File(uri);
        return ReadFileExtensions.toByteArray(tmpFile);
    }

    public static String getAbsolutPathWithoutFilename(File file) {
        return RenameFileExtensions.getAbsolutPathWithoutFilename(file);
    }

    public static String getCurrentAbsolutPathWithoutDotAndSlash() {
        File currentAbsolutPath = new File(".");
        return currentAbsolutPath.getAbsolutePath().substring(0, currentAbsolutPath.getAbsolutePath().length() - 2);
    }

    public static String getFilenamePrefix(File file) {
        return FilenameExtensions.getFilenamePrefix((File)file);
    }

    public static String getFilenameSuffix(File file) {
        return FilenameExtensions.getFilenameSuffix((File)file);
    }

    public static String getFilenameWithoutExtension(File file) {
        return FilenameExtensions.getFilenameWithoutExtension((File)file);
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpen(File file) {
        boolean open = false;
        RandomAccessFile fileAccess = null;
        FileLock lock = null;
        try {
            fileAccess = new RandomAccessFile(file.getAbsolutePath(), "rw");
            lock = fileAccess.getChannel().tryLock();
            if (lock == null) {
                open = true;
            } else {
                lock.release();
            }
        }
        catch (FileNotFoundException fnfe) {
            open = true;
        }
        catch (IOException ioe) {
            open = true;
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.close();
                    fileAccess = null;
                }
                catch (IOException ioex) {
                    LOGGER.error((Object)ioex);
                }
            }
        }
        return open;
    }
}

