/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.write;

import de.alpharogroup.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class WriteFileExtensions {
    private static final Logger LOGGER = Logger.getLogger((String)WriteFileExtensions.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void readSourceFileAndWriteDestFile(String srcfile, String destFile) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(srcfile);
            fos = new FileOutputStream(destFile);
            bis = new BufferedInputStream(fis);
            bos = new BufferedOutputStream(fos);
            int availableLength = bis.available();
            byte[] totalBytes = new byte[availableLength];
            bis.read(totalBytes, 0, availableLength);
            bos.write(totalBytes, 0, availableLength);
            bos.flush();
            bis.close();
            bos.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("readSourceFileAndWriteDestFile failed...\n" + e.getMessage()), (Throwable)e);
            StreamExtensions.closeInputStream((InputStream)bis);
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeInputStream((InputStream)fis);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("readSourceFileAndWriteDestFile failed...\n" + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeInputStream(bis);
                    StreamExtensions.closeOutputStream(bos);
                    StreamExtensions.closeInputStream((InputStream)fis);
                    StreamExtensions.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
            }
            StreamExtensions.closeInputStream((InputStream)bis);
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeInputStream((InputStream)fis);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        StreamExtensions.closeInputStream((InputStream)bis);
        StreamExtensions.closeOutputStream((OutputStream)bos);
        StreamExtensions.closeInputStream((InputStream)fis);
        StreamExtensions.closeOutputStream((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void storeByteArrayToFile(byte[] data, File file) {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(data);
            bos.flush();
            bos.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("storeByteArrayToFile failed...\n" + e.getMessage()), (Throwable)e);
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("storeByteArrayToFile failed...\n" + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeOutputStream(bos);
                    StreamExtensions.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
            }
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        StreamExtensions.closeOutputStream((OutputStream)bos);
        StreamExtensions.closeOutputStream((OutputStream)fos);
    }

    public static boolean string2File(File file, String string2write) {
        return WriteFileExtensions.writeStringToFile(file, string2write, null);
    }

    public static boolean string2File(File file, String string2write, String encoding) {
        return WriteFileExtensions.writeStringToFile(file, string2write, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void string2File(String string2write, String nameOfFile) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(nameOfFile));
            bufferedWriter.write(string2write);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("string2File failed...\n" + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamExtensions.closeWriter(bufferedWriter);
                throw throwable;
            }
            StreamExtensions.closeWriter((Writer)bufferedWriter);
        }
        StreamExtensions.closeWriter((Writer)bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream inputStream, OutputStream outputStream) throws FileNotFoundException, IOException {
        try {
            int counter;
            byte[] byteArray = new byte[8192];
            while ((counter = inputStream.read(byteArray)) != -1) {
                outputStream.write(byteArray, 0, counter);
            }
        }
        finally {
            StreamExtensions.closeInputStream((InputStream)inputStream);
            StreamExtensions.closeOutputStream((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write2File(Reader reader, Writer writer, boolean closeStream) {
        try {
            int byt;
            while ((byt = reader.read()) != -1) {
                writer.write(byt);
            }
            if (closeStream) {
                reader.close();
                writer.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (closeStream) {
                StreamExtensions.closeReader((Reader)reader);
                StreamExtensions.closeWriter((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void write2File(String inputFile, String outputFile) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(inputFile);
            fos = new FileOutputStream(outputFile);
            bis = new BufferedInputStream(fis);
            bos = new BufferedOutputStream(fos);
            StreamExtensions.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos, (boolean)true);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
            StreamExtensions.closeInputStream((InputStream)fis);
            StreamExtensions.closeOutputStream((OutputStream)fos);
            StreamExtensions.closeInputStream((InputStream)bis);
            StreamExtensions.closeOutputStream((OutputStream)bos);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("write2File failed...\n" + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeInputStream(fis);
                    StreamExtensions.closeOutputStream(fos);
                    StreamExtensions.closeInputStream(bis);
                    StreamExtensions.closeOutputStream(bos);
                    throw throwable;
                }
            }
            StreamExtensions.closeInputStream((InputStream)fis);
            StreamExtensions.closeOutputStream((OutputStream)fos);
            StreamExtensions.closeInputStream((InputStream)bis);
            StreamExtensions.closeOutputStream((OutputStream)bos);
        }
        StreamExtensions.closeInputStream((InputStream)fis);
        StreamExtensions.closeOutputStream((OutputStream)fos);
        StreamExtensions.closeInputStream((InputStream)bis);
        StreamExtensions.closeOutputStream((OutputStream)bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write2File(String inputFile, Writer writer, boolean closeWriter) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(inputFile));
            WriteFileExtensions.write2File(bufferedReader, writer, closeWriter);
            if (!closeWriter) return;
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error((Object)("write2File failed...\n" + e.getMessage()), (Throwable)e);
                if (!closeWriter) return;
            }
            catch (Throwable throwable) {
                if (!closeWriter) throw throwable;
                StreamExtensions.closeReader(bufferedReader);
                StreamExtensions.closeWriter((Writer)writer);
                throw throwable;
            }
            StreamExtensions.closeReader((Reader)bufferedReader);
            StreamExtensions.closeWriter((Writer)writer);
            return;
        }
        StreamExtensions.closeReader((Reader)bufferedReader);
        StreamExtensions.closeWriter((Writer)writer);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void write2FileWithBuffer(String inputFile, String outputFile) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = StreamExtensions.getInputStream((File)new File(inputFile));
            outputStream = StreamExtensions.getOutputStream((File)new File(outputFile));
            WriteFileExtensions.write(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("write2FileWithBuffer failed...\n" + e.getMessage()), (Throwable)e);
            StreamExtensions.closeInputStream((InputStream)inputStream);
            StreamExtensions.closeOutputStream((OutputStream)outputStream);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("write2FileWithBuffer failed...\n" + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeInputStream(inputStream);
                    StreamExtensions.closeOutputStream(outputStream);
                    throw throwable;
                }
            }
            StreamExtensions.closeInputStream((InputStream)inputStream);
            StreamExtensions.closeOutputStream((OutputStream)outputStream);
        }
        StreamExtensions.closeInputStream((InputStream)inputStream);
        StreamExtensions.closeOutputStream((OutputStream)outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeByteArrayToFile(File file, byte[] byteArray) throws IOException {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(byteArray);
            fos.close();
            fos = null;
            bos = null;
        }
        catch (FileNotFoundException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                StreamExtensions.closeOutputStream(fos);
                StreamExtensions.closeOutputStream(bos);
                throw throwable;
            }
        }
        StreamExtensions.closeOutputStream((OutputStream)fos);
        StreamExtensions.closeOutputStream((OutputStream)bos);
    }

    public static void writeByteArrayToFile(String filename, byte[] byteArray) throws IOException {
        File file = new File(filename);
        WriteFileExtensions.writeByteArrayToFile(file, byteArray);
    }

    public static void writeLinesToFile(Collection<String> collection, File output) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileExtensions.string2File(output, sb.toString());
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileExtensions.string2File(output, sb.toString(), encoding);
    }

    /*
     * Exception decompiling
     */
    public static void writeLinesToFile(File output, List<String> input, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties2File(String filename, Properties properties) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            properties.store(fos, null);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("writeProperties2File failed...\n" + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamExtensions.closeOutputStream(fos);
                throw throwable;
            }
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        StreamExtensions.closeOutputStream((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean writeStringToFile(File file, String string2write, String encoding) {
        boolean iswritten = true;
        PrintWriter printWriter = null;
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            osw = null == encoding ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
            printWriter = new PrintWriter(osw);
            printWriter.write(string2write);
            printWriter.close();
            osw.close();
            bos.close();
            fos.close();
            printWriter = null;
            osw = null;
            bos = null;
            fos = null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("writeStringToFile failed...\n" + e.getMessage()), (Throwable)e);
            iswritten = false;
            StreamExtensions.closeWriter(printWriter);
            StreamExtensions.closeWriter((Writer)osw);
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("writeStringToFile failed...\n" + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeWriter(printWriter);
                    StreamExtensions.closeWriter(osw);
                    StreamExtensions.closeOutputStream((OutputStream)bos);
                    StreamExtensions.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
            }
            StreamExtensions.closeWriter(printWriter);
            StreamExtensions.closeWriter((Writer)osw);
            StreamExtensions.closeOutputStream((OutputStream)bos);
            StreamExtensions.closeOutputStream((OutputStream)fos);
        }
        StreamExtensions.closeWriter((Writer)printWriter);
        StreamExtensions.closeWriter((Writer)osw);
        StreamExtensions.closeOutputStream((OutputStream)bos);
        StreamExtensions.closeOutputStream((OutputStream)fos);
        return iswritten;
    }

    private WriteFileExtensions() {
    }
}

