/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PathFinder {
    public static final String SOURCE_FOLDER_SRC_MAIN_RESOURCES = "src/main/resources";
    public static final String SOURCE_FOLDER_SRC_MAIN_JAVA = "src/main/java";
    public static final String SOURCE_FOLDER_SRC_TEST_RESOURCES = "src/test/resources";
    public static final String SOURCE_FOLDER_SRC_TEST_JAVA = "src/test/java";

    public static String getAbsolutePath(File file, boolean removeLastChar) {
        String absolutePath = file.getAbsolutePath();
        if (removeLastChar) {
            absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
        }
        return absolutePath;
    }

    public static File getProjectDirectory() {
        return PathFinder.getProjectDirectory(new File("."));
    }

    public static File getProjectDirectory(File currentDir) {
        String projectPath = PathFinder.getAbsolutePath(currentDir, true);
        File projectFile = new File(projectPath);
        return projectFile;
    }

    public static File getRelativePath(File parent, String ... folders) {
        return PathFinder.getRelativePathTo(parent, Arrays.asList(folders));
    }

    public static File getRelativePathTo(File parent, List<String> folders) {
        for (String string : folders) {
            File nextFolder;
            parent = nextFolder = new File(parent, string);
        }
        return parent;
    }

    public static File getRelativePathTo(File parent, String separator, String folders, String filename) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(folders.split(separator)));
        if (filename != null && !filename.isEmpty()) {
            list.add(filename);
        }
        return PathFinder.getRelativePathTo(parent, list);
    }

    public static File getSrcMainJavaDir() {
        return new File(PathFinder.getProjectDirectory(), SOURCE_FOLDER_SRC_MAIN_JAVA);
    }

    public static File getSrcMainJavaDir(File projectDirectory) {
        return new File(projectDirectory, SOURCE_FOLDER_SRC_MAIN_JAVA);
    }

    public static File getSrcMainResourcesDir() {
        return new File(PathFinder.getProjectDirectory(), SOURCE_FOLDER_SRC_MAIN_RESOURCES);
    }

    public static File getSrcMainResourcesDir(File projectDirectory) {
        return new File(projectDirectory, SOURCE_FOLDER_SRC_MAIN_RESOURCES);
    }

    public static File getSrcTestJavaDir() {
        return new File(PathFinder.getProjectDirectory(), SOURCE_FOLDER_SRC_TEST_JAVA);
    }

    public static File getSrcTestJavaDir(File projectDirectory) {
        return new File(projectDirectory, SOURCE_FOLDER_SRC_TEST_JAVA);
    }

    public static File getSrcTestResourcesDir() {
        return new File(PathFinder.getProjectDirectory(), SOURCE_FOLDER_SRC_TEST_RESOURCES);
    }

    public static File getSrcTestResourcesDir(File projectDirectory) {
        return new File(projectDirectory, SOURCE_FOLDER_SRC_TEST_RESOURCES);
    }

    private PathFinder() {
    }
}

