/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.read;

import de.alpharogroup.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class ReadFileExtensions {
    private static final Logger LOGGER = Logger.getLogger(ReadFileExtensions.class.getName());

    public static Byte[] getFilecontentAsByteObjectArray(File tmpFile) {
        return ReadFileExtensions.toObject(ReadFileExtensions.toByteArray(tmpFile));
    }

    public static String inputStream2String(InputStream inputStream) {
        return ReadFileExtensions.inputStream2String(inputStream, Charset.forName("UTF-8"));
    }

    public static String inputStream2String(InputStream inputStream, Charset encoding) {
        return ReadFileExtensions.reader2String(new InputStreamReader(inputStream, encoding));
    }

    public static Reader openFileReader(String fileName) throws IOException {
        BufferedReader bufferedReader = null;
        File file = new File(fileName);
        bufferedReader = (BufferedReader)StreamExtensions.getReader((File)file);
        return bufferedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader2String(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] charArray = new char[8192];
        try {
            int tmp;
            while ((tmp = reader.read(charArray)) > 0) {
                stringBuffer.append(charArray, 0, tmp);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "reader2String failed...\n" + e.getMessage(), e);
        }
        finally {
            StreamExtensions.closeReader((Reader)reader);
        }
        return stringBuffer.toString();
    }

    public static byte[] readFileToBytearray(File file) {
        return ReadFileExtensions.toByteArray(file);
    }

    public static String readFromFile(File file) throws IOException {
        return ReadFileExtensions.inputStream2String(StreamExtensions.getInputStream((File)file));
    }

    public static String readFromFile(File file, Charset encoding) throws IOException {
        return ReadFileExtensions.inputStream2String(StreamExtensions.getInputStream((File)file), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readHeadLine(String inputFile) {
        BufferedReader reader = null;
        String headLine = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            headLine = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, "readHeadLine failed...\n" + e.getMessage(), e);
            StreamExtensions.closeReader((Reader)reader);
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, "readHeadLine failed...\n" + e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    StreamExtensions.closeReader(reader);
                    throw throwable;
                }
            }
            StreamExtensions.closeReader((Reader)reader);
        }
        StreamExtensions.closeReader((Reader)reader);
        return headLine;
    }

    public static List<String> readLinesInList(File input) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static List<String> readLinesInList(File input, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), trim);
    }

    public static List<String> readLinesInList(File input, Charset encoding) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, encoding, false);
    }

    public static List<String> readLinesInList(File input, Charset encoding, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), encoding, trim);
    }

    public static List<String> readLinesInList(InputStream input) throws IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static List<String> readLinesInList(InputStream input, boolean trim) throws IOException {
        return ReadFileExtensions.readLinesInList(input, null, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesInList(InputStream input, Charset encoding, boolean trim) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            isr = encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding);
            reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (trim) {
                    line.trim();
                }
                output.add(line);
            }
        }
        catch (Throwable throwable) {
            StreamExtensions.closeReader(isr);
            StreamExtensions.closeReader(reader);
            throw throwable;
        }
        StreamExtensions.closeReader((Reader)isr);
        StreamExtensions.closeReader((Reader)reader);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFromFile(String filename) {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            properties.load(fis);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.SEVERE, "readPropertiesFromFile failed...\n" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                StreamExtensions.closeInputStream(fis);
                throw throwable;
            }
            StreamExtensions.closeInputStream((InputStream)fis);
        }
        StreamExtensions.closeInputStream((InputStream)fis);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File tmpFile) {
        byte[] data = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        if (tmpFile.exists() && !tmpFile.isDirectory()) {
            try {
                bos = new ByteArrayOutputStream(1024);
                bis = new BufferedInputStream(new FileInputStream(tmpFile));
                StreamExtensions.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos, (boolean)false);
                data = bos.toByteArray();
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "transformFilecontentToByteArray failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamExtensions.closeInputStream(bis);
                    StreamExtensions.closeOutputStream((OutputStream)bos);
                    throw throwable;
                }
                StreamExtensions.closeInputStream((InputStream)bis);
                StreamExtensions.closeOutputStream((OutputStream)bos);
            }
            StreamExtensions.closeInputStream((InputStream)bis);
            StreamExtensions.closeOutputStream((OutputStream)bos);
        }
        return data;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    private static Byte[] toObject(byte[] byteArray) {
        return ArrayUtils.toObject((byte[])byteArray);
    }

    private ReadFileExtensions() {
    }
}

