/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.csv;

import de.alpharogroup.file.write.WriteFileExtensions;
import de.alpharogroup.io.StreamExtensions;
import de.alpharogroup.string.StringExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class CsvFileExtensions {
    /*
     * Exception decompiling
     */
    public static List<String> formatKommaSeperatedFileToList(File input, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String formatListToString(List<String> list) {
        int lineLength = 0;
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            int length = str.length();
            lineLength = length + lineLength;
            sb.append(str);
            sb.append(", ");
            if (100 >= lineLength) continue;
            sb.append("\n");
            lineLength = 0;
        }
        return sb.toString().trim();
    }

    public static void formatToCSV(File input, File output, String encoding) throws IOException {
        List<String> list = CsvFileExtensions.readLinesInList(input, "UTF-8");
        String sb = CsvFileExtensions.formatListToString(list);
        WriteFileExtensions.writeStringToFile(output, sb, encoding);
    }

    public static List<Map<String, String>> getCvsAsListMap(File input) throws IOException {
        List<String[]> lines = CsvFileExtensions.readFileToList(input, ";", "UTF-8");
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        String[] headline = lines.remove(0);
        for (String[] line : lines) {
            LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
            String[] currentLine = line;
            for (int j = 0; j < currentLine.length; ++j) {
                context.put(headline[j], currentLine[j]);
            }
            data.add(context);
        }
        return data;
    }

    public static String[] getDataFromLine(String line, String seperator) {
        return CsvFileExtensions.getDataFromLine(line, seperator, false);
    }

    public static String[] getDataFromLine(String line, String seperator, boolean trim) {
        StringTokenizer tokenizer = new StringTokenizer(line, seperator);
        ArrayList<String> data = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String string = tokenizer.nextToken();
            if (trim) {
                data.add(string.trim());
                continue;
            }
            data.add(string);
        }
        String[] splittedLine = data.toArray(new String[0]);
        return splittedLine;
    }

    public static int getLineCountFromCsvFile(File file) throws IOException {
        return CsvFileExtensions.readFileToList(file).size();
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String[] splittedData;
            reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null && position < (splittedData = line.split(",")).length - 1) {
                String s = StringExtensions.removeQuotationMarks((String)splittedData[position]);
                output.add(s);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        if (putFirstLine) {
            output.remove(0);
        }
        return output;
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String splitChar, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedData = line.split(splitChar);
                if (position > splittedData.length - 1) continue;
                String s = StringExtensions.removeQuotationMarks((String)splittedData[position]);
                output.add(s);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        if (putFirstLine) {
            output.remove(0);
        }
        return output;
    }

    public static Properties readFilelistToProperties(File input) throws IOException {
        List<String> list = CsvFileExtensions.readLinesInList(input, null);
        Properties prop = new Properties();
        for (int i = 0; i < list.size(); ++i) {
            String element = list.get(i);
            prop.put(i + "", element);
        }
        return prop;
    }

    public static List<String> readFileToList(File file) throws IOException {
        return CsvFileExtensions.readFileToList(file, null);
    }

    public static List<String> readFileToList(File file, String encoding) throws IOException {
        ArrayList<String> fn = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamExtensions.getReader((File)file, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                fn.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        return fn;
    }

    public static List<String[]> readFileToList(File file, String seperator, String encoding) throws IOException {
        ArrayList<String[]> fn = new ArrayList<String[]>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamExtensions.getReader((File)file, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedLine = CsvFileExtensions.getDataFromLine(line, seperator);
                fn.add(splittedLine);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        return fn;
    }

    public static List<String> readLinesInList(File input, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        return output;
    }

    public static String[] sortData(File csvData, String encoding) throws FileNotFoundException, IOException {
        ArrayList<String> fn = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamExtensions.getReader((File)csvData, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                int last = 0;
                int index = line.indexOf(44);
                while (index != -1) {
                    String firstname = line.substring(last, index).trim();
                    fn.add(firstname);
                    last = index + 1;
                    index = line.indexOf(44, last);
                }
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeReader(reader);
                throw throwable;
            }
        }
        StreamExtensions.closeReader((Reader)reader);
        Object[] data = fn.toArray(new String[fn.size()]);
        Arrays.sort(data);
        return data;
    }

    public static void storeFilelistToProperties(File output, File input, String comments) throws IOException {
        Properties prop = CsvFileExtensions.readFilelistToProperties(input);
        OutputStream out = StreamExtensions.getOutputStream((File)output, (boolean)true);
        prop.store(out, comments);
        StreamExtensions.closeOutputStream((OutputStream)out);
    }

    public static void writeLines(File output, Set<String> values, String encoding) throws IOException {
        CsvFileExtensions.writeLinesToFile(values, output, encoding);
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileExtensions.writeStringToFile(output, sb.toString(), encoding);
    }

    private CsvFileExtensions() {
    }
}

