/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.checksum;

import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.io.StreamExtensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public final class ChecksumExtensions {
    protected static final Logger LOGGER = Logger.getLogger((String)ChecksumExtensions.class.getName());

    private static void checkWithByteArray(byte[] data) throws NoSuchAlgorithmException {
        Algorithm[] algorithms;
        for (Algorithm algorithm : algorithms = Algorithm.values()) {
            try {
                String result = ChecksumExtensions.getChecksum(data, algorithm.getAlgorithm());
                LOGGER.info((Object)("getChecksum from " + algorithm + " algorithm:\t\t" + result));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    private static void checkWithFile(File pom) throws NoSuchAlgorithmException {
        Algorithm[] algorithms;
        for (Algorithm algorithm : algorithms = Algorithm.values()) {
            try {
                String result = ChecksumExtensions.getChecksum(pom, algorithm.getAlgorithm());
                LOGGER.info((Object)("getChecksum from " + algorithm + " algorithm:\t\t" + result));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public static String getChecksum(byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        messageDigest.update(bytes);
        byte[] digest = messageDigest.digest();
        StringBuilder hexView = new StringBuilder();
        for (byte element : digest) {
            String intAsHex = Integer.toHexString(0xFF & element);
            if (intAsHex.length() == 1) {
                hexView.append('0');
            }
            hexView.append(intAsHex);
        }
        return hexView.toString();
    }

    public static String getChecksum(Byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(Byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(ArrayUtils.toPrimitive((Byte[])bytes), algorithm);
    }

    public static String getChecksum(File file, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
    }

    public static long getChecksum(File file, boolean crc) throws FileNotFoundException, IOException {
        CheckedInputStream cis = null;
        cis = crc ? new CheckedInputStream(new FileInputStream(file), new CRC32()) : new CheckedInputStream(new FileInputStream(file), new Adler32());
        int length = (int)file.length();
        byte[] buffer = new byte[length];
        long checksum = 0L;
        while (cis.read(buffer) >= 0) {
            checksum = cis.getChecksum().getValue();
        }
        checksum = cis.getChecksum().getValue();
        StreamExtensions.closeInputStream((InputStream)cis);
        return checksum;
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(ReadFileExtensions.toByteArray(file), algorithm);
    }

    public static long getCheckSumAdler32(byte[] bytes) {
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumAdler32(File file) {
        return ChecksumExtensions.getCheckSumAdler32(ReadFileExtensions.toByteArray(file));
    }

    public static long getCheckSumCRC32(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumCRC32(File file) {
        return ChecksumExtensions.getCheckSumCRC32(ReadFileExtensions.toByteArray(file));
    }

    public static String getChecksumQuietly(byte[] bytes, Algorithm algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("getChecksumQuietly failed...\n" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String getChecksumQuietly(byte[] bytes, String algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("getChecksumQuietly failed...\n" + e.getMessage()), (Throwable)e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(Byte[] bytes, String algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("getChecksumQuietly failed...\n" + e.getMessage()), (Throwable)e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(File file, Algorithm algorithm) {
        try {
            return ChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("getChecksumQuietly failed...\n" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        if (args.length != 1) {
            System.err.println("Usage: java ChecksumCRC32 filename");
        } else {
            File pom = new File(args[0]);
            ChecksumExtensions.checkWithFile(pom);
            long checksum = ChecksumExtensions.getChecksum(new File(args[0]), true);
            System.out.println("CRC32 checksum:" + checksum);
            checksum = ChecksumExtensions.getChecksum(new File(args[0]), false);
            System.out.println("Adler32 checksum:" + checksum);
            byte[] ba = ReadFileExtensions.readFileToBytearray(pom);
            ChecksumExtensions.checkWithByteArray(ba);
        }
    }

    private ChecksumExtensions() {
    }
}

