/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.export.excel.poi;

import de.alpharogroup.check.Check;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelPoiFactory {
    public static CellStyle newCellStyle(Workbook workbook, String fontName, short boldweight, short height) {
        CellStyle boldFontCellStyle = workbook.createCellStyle();
        boldFontCellStyle.setFont(ExcelPoiFactory.newFont(workbook, fontName, boldweight, height));
        return boldFontCellStyle;
    }

    public static CellStyle newDateCellStyle(Workbook workbook, String dateFormat) {
        CellStyle dateCellStyle = workbook.createCellStyle();
        dateCellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(dateFormat));
        return dateCellStyle;
    }

    public static Font newFont(Workbook workbook, String fontName, short boldweight, short height) {
        Font font = workbook.createFont();
        font.setFontName(fontName);
        font.setBoldweight(boldweight);
        font.setFontHeightInPoints(height);
        return font;
    }

    public static Workbook newHSSFWorkbook(File file) throws IOException {
        return ExcelPoiFactory.writeWorkbook((Workbook)new HSSFWorkbook(), file);
    }

    public static Workbook newHSSFWorkbook(String pathname) throws IOException {
        Check.get().notNull((Object)pathname, "pathname");
        return ExcelPoiFactory.newHSSFWorkbook(new File(pathname));
    }

    public static Sheet newSheet(Workbook workbook, String name) {
        return workbook.createSheet(WorkbookUtil.createSafeSheetName((String)name));
    }

    public static Workbook newXSSFWorkbook(File file) throws IOException {
        return ExcelPoiFactory.writeWorkbook((Workbook)new XSSFWorkbook(), file);
    }

    public static Workbook writeWorkbook(Workbook workbook, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        return workbook;
    }
}

