/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service.util;

import de.alpharogroup.event.system.entities.Categories;
import de.alpharogroup.event.system.entities.EventLocations;
import de.alpharogroup.event.system.entities.EventMessages;
import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.message.system.entities.Messages;

public class HqlStringCreator {
    public static void appendCondition(StringBuilder sb, String fieldName, String firstLetter, boolean ... isNotNull) {
        boolean concatenated = false;
        for (int i = 0; i < isNotNull.length; ++i) {
            concatenated = i == 0 ? !isNotNull[i] : concatenated && !isNotNull[i];
        }
        sb.append(" ");
        String condition = firstLetter + "." + fieldName + "=:" + fieldName;
        if (concatenated) {
            sb.append("where " + condition);
        } else {
            sb.append("and " + condition);
        }
    }

    public static String forCategories(String name, Class<Categories> clazz) {
        boolean nameIsNotNull;
        StringBuilder sb = HqlStringCreator.getSimpleSelect(clazz, true);
        String firstLetter = HqlStringCreator.getFirstLetterLowerCase(clazz);
        boolean bl = nameIsNotNull = name != null && !name.isEmpty();
        if (nameIsNotNull) {
            sb.append(" ");
            sb.append("where " + firstLetter + ".name=:name");
        }
        return sb.toString();
    }

    public static String forEventMessages(Messages message, EventLocations eventLocation, Class<EventMessages> clazz) {
        boolean eventLocationIsNotNull;
        boolean messagesIsNotNull;
        StringBuilder sb = HqlStringCreator.getSimpleSelect(clazz, true);
        String firstLetter = HqlStringCreator.getFirstLetterLowerCase(clazz);
        boolean bl = messagesIsNotNull = message != null;
        if (messagesIsNotNull) {
            sb.append(" ");
            sb.append("where " + firstLetter + ".message=:message");
        }
        boolean bl2 = eventLocationIsNotNull = eventLocation != null;
        if (eventLocationIsNotNull) {
            HqlStringCreator.appendCondition(sb, "eventLocation", firstLetter, messagesIsNotNull);
        }
        return sb.toString();
    }

    public static String forTopics(String name, Boolean node, Topics parent) {
        boolean parentIsNotNull;
        boolean nodeIsNotNull;
        boolean nameIsNotNull;
        StringBuilder sb = HqlStringCreator.getSimpleSelect(Topics.class, true);
        String firstLetter = HqlStringCreator.getFirstLetterLowerCase(Topics.class);
        boolean bl = nameIsNotNull = name != null && !name.isEmpty();
        if (nameIsNotNull) {
            HqlStringCreator.appendCondition(sb, "name", firstLetter, true);
        }
        boolean bl2 = nodeIsNotNull = node != null;
        if (nodeIsNotNull) {
            HqlStringCreator.appendCondition(sb, "node", firstLetter, nameIsNotNull);
        }
        boolean bl3 = parentIsNotNull = parent != null;
        if (parentIsNotNull) {
            HqlStringCreator.appendCondition(sb, "parent", firstLetter, nameIsNotNull, nodeIsNotNull);
        }
        return sb.toString();
    }

    public static String getFirstLetterLowerCase(Class<?> clazz) {
        String simpleClassName = clazz.getSimpleName();
        String firstLetter = simpleClassName.substring(0, 1).toLowerCase();
        return firstLetter;
    }

    public static StringBuilder getSimpleSelect(Class<?> clazz, boolean distinct) {
        StringBuilder sb = new StringBuilder();
        String firstLetter = HqlStringCreator.getFirstLetterLowerCase(clazz);
        if (distinct) {
            sb.append("select distinct " + firstLetter + " from " + clazz.getSimpleName() + " " + firstLetter);
        } else {
            sb.append("select " + firstLetter + " from " + clazz.getSimpleName() + " " + firstLetter);
        }
        return sb;
    }
}

