/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.application.model.TopicTreeNode;
import de.alpharogroup.event.system.daos.TopicsDao;
import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.event.system.service.api.TopicsService;
import de.alpharogroup.event.system.service.util.HqlStringCreator;
import de.alpharogroup.tree.ifaces.ITreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="topicsService")
public class TopicsBusinessService
extends AbstractBusinessService<Topics, Integer, TopicsDao>
implements TopicsService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Topics> find(String name, Boolean node, Topics parent) {
        String hqlString = HqlStringCreator.forTopics(name, node, parent);
        Query query = this.getQuery(hqlString);
        if (name != null) {
            query.setParameter("name", (Object)name);
        }
        if (node != null) {
            query.setParameter("node", (Object)node);
        }
        if (parent != null) {
            query.setParameter("parent", (Object)parent);
        }
        List topics = query.getResultList();
        return topics;
    }

    @Override
    public List<Topics> getChildren(Topics topic) {
        return this.find(null, null, topic);
    }

    @Override
    public Iterator<? extends Topics> getIteratorForChildren(Topics topic) {
        List<Topics> topics = this.getChildren(topic);
        if (null != topics && !topics.isEmpty()) {
            return topics.iterator();
        }
        return null;
    }

    @Override
    public Topics getRoot() {
        return (Topics)this.get(Integer.valueOf(1));
    }

    @Override
    public ITreeNode<Topics> getRootTreeNode() {
        return this.getTreeNode(this.getRoot());
    }

    @Override
    public void getTopicTreeRecursive(ITreeNode<Topics> taskElement) {
        List<Topics> children = this.getChildren((Topics)taskElement.getValue());
        ArrayList<TopicTreeNode> childElements = new ArrayList<TopicTreeNode>();
        if (children != null) {
            for (Topics childTopic : children) {
                TopicTreeNode childElement = new TopicTreeNode(childTopic);
                childElements.add(childElement);
                this.getTopicTreeRecursive((ITreeNode<Topics>)childElement);
            }
            taskElement.setChildren(childElements);
        }
    }

    @Override
    public ITreeNode<Topics> getTreeNode(Topics topic) {
        TopicTreeNode root = new TopicTreeNode(topic);
        this.getTopicTreeRecursive((ITreeNode<Topics>)root);
        return root;
    }

    @Override
    public boolean hasChildren(Topics topic) {
        List<Topics> topics = this.getChildren(topic);
        return null != topics && !topics.isEmpty();
    }

    @Override
    public boolean hasParent(Topics topic) {
        return null != topic.getParent();
    }

    @Autowired
    public void setTopicsDao(TopicsDao topicsDao) {
        this.setDao((EntityManagerDao)topicsDao);
    }
}

