/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.ProfileTopicsDao;
import de.alpharogroup.event.system.entities.ProfileTopics;
import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.event.system.service.api.ProfileTopicsService;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="profileTopicsService")
public class ProfileTopicsBusinessService
extends AbstractBusinessService<ProfileTopics, Integer, ProfileTopicsDao>
implements ProfileTopicsService {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean contains(Topics topic, Users user) {
        return this.findProfileTopic(topic, user) != null;
    }

    @Override
    public void deleteWithAllReferences(ProfileTopics profileTopics) {
        if (profileTopics != null) {
            profileTopics.setUser(null);
            profileTopics.setTopic(null);
            profileTopics = (ProfileTopics)this.merge((BaseEntity)profileTopics);
            this.delete((BaseEntity)profileTopics);
        }
    }

    @Override
    public ProfileTopics findProfileTopic(Topics topic, Users user) {
        String hqlString = "select pt from ProfileTopics pt where pt.user=:user and pt.topic=:topic";
        Query query = this.getQuery("select pt from ProfileTopics pt where pt.user=:user and pt.topic=:topic");
        query.setParameter("user", (Object)user);
        query.setParameter("topic", (Object)topic);
        List profileTopics = query.getResultList();
        return (ProfileTopics)ListExtensions.getFirst((List)profileTopics);
    }

    @Override
    public List<ProfileTopics> findProfileTopics(Users user) {
        String hqlString = "select pt from ProfileTopics pt where pt.user=:user";
        Query query = this.getQuery("select pt from ProfileTopics pt where pt.user=:user");
        query.setParameter("user", (Object)user);
        List profileTopics = query.getResultList();
        return profileTopics;
    }

    @Autowired
    public void setProfileTopicsDao(ProfileTopicsDao profileTopicsDao) {
        this.setDao((EntityManagerDao)profileTopicsDao);
    }
}

