/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.entities.Federalstates;
import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.ProfileFederalstatesDao;
import de.alpharogroup.event.system.entities.ProfileFederalstates;
import de.alpharogroup.event.system.service.api.ProfileFederalstatesService;
import de.alpharogroup.user.entities.Users;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="profileFederalstatesService")
public class ProfileFederalstatesBusinessService
extends AbstractBusinessService<ProfileFederalstates, Integer, ProfileFederalstatesDao>
implements ProfileFederalstatesService {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean contains(Federalstates federalstate, Users user) {
        return this.findProfileFederalstate(federalstate, user) != null;
    }

    @Override
    public void deleteWithAllReferences(ProfileFederalstates profileFederalstate) {
        profileFederalstate.setUser(null);
        profileFederalstate.setFederalstate(null);
        profileFederalstate = (ProfileFederalstates)this.merge((BaseEntity)profileFederalstate);
        this.delete((BaseEntity)profileFederalstate);
    }

    @Override
    public ProfileFederalstates findProfileFederalstate(Federalstates federalstate, Users user) {
        String hqlString = "select pf from ProfileFederalstates pf where pf.user=:user and pf.federalstate=:federalstate";
        Query query = this.getQuery("select pf from ProfileFederalstates pf where pf.user=:user and pf.federalstate=:federalstate");
        query.setParameter("user", (Object)user);
        query.setParameter("federalstate", (Object)federalstate);
        List profileFederalstates = query.getResultList();
        return (ProfileFederalstates)ListExtensions.getFirst((List)profileFederalstates);
    }

    @Override
    public List<ProfileFederalstates> findProfileFederalstates(Users user) {
        String hqlString = "select pf from ProfileFederalstates pf where pf.user=:user";
        Query query = this.getQuery("select pf from ProfileFederalstates pf where pf.user=:user");
        query.setParameter("user", (Object)user);
        List profileFederalstates = query.getResultList();
        return profileFederalstates;
    }

    @Autowired
    public void setProfileFederalstatesDao(ProfileFederalstatesDao profileFederalstatesDao) {
        this.setDao((EntityManagerDao)profileFederalstatesDao);
    }

    @Override
    public List<String> toStringList(List<ProfileFederalstates> profileFederalstates) {
        ArrayList<String> selectedFederalstates = new ArrayList<String>();
        for (ProfileFederalstates profileFederalstate : profileFederalstates) {
            String result;
            Federalstates federalstate = profileFederalstate.getFederalstate();
            if (federalstate == null) continue;
            Countries country = federalstate.getCountry();
            if (country == null) {
                String federalstateName;
                result = federalstateName = federalstate.getName();
            } else {
                String splitString = "=>";
                String countryName = country.getName();
                String iso3166A2code = federalstate.getIso3166A2code();
                result = countryName + splitString + iso3166A2code;
            }
            selectedFederalstates.add(result);
        }
        return selectedFederalstates;
    }
}

