/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.OfferedEventLocationsDao;
import de.alpharogroup.event.system.entities.OfferedEventLocations;
import de.alpharogroup.event.system.service.api.OfferedEventLocationsService;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="offeredEventLocationsService")
public class OfferedEventLocationsBusinessService
extends AbstractBusinessService<OfferedEventLocations, Integer, OfferedEventLocationsDao>
implements OfferedEventLocationsService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<OfferedEventLocations> findOfferedEventLocationsFromUser(Users user) {
        String hqlString = "select distinct oel from OfferedEventLocations oel where oel.provider=:user";
        Query query = this.getQuery(hqlString);
        query.setParameter("user", (Object)user);
        List offeredEventLocations = query.getResultList();
        return offeredEventLocations;
    }

    @Override
    public List<OfferedEventLocations> findOfferedEventLocationsFromZipcodeAndCity(String zipcode, String city) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct oel from OfferedEventLocations oel");
        if (StringUtils.isNotEmpty((String)zipcode) || StringUtils.isNotEmpty((String)city)) {
            sb.append(" where");
        }
        if (StringUtils.isNotEmpty((String)zipcode)) {
            sb.append(" oel.userAddress.zipcode.zipcode=:zipcode");
        }
        if (StringUtils.isNotEmpty((String)zipcode) && StringUtils.isNotEmpty((String)city)) {
            sb.append(" or");
        }
        if (StringUtils.isNotEmpty((String)city)) {
            sb.append(" oel.userAddress.zipcode.city=:city");
        }
        Query query = this.getQuery(sb.toString());
        if (StringUtils.isNotEmpty((String)zipcode)) {
            query.setParameter("zipcode", (Object)zipcode);
        }
        if (StringUtils.isNotEmpty((String)city)) {
            query.setParameter("city", (Object)city);
        }
        List offeredEventLocations = query.getResultList();
        return offeredEventLocations;
    }

    @Autowired
    public void setOfferedEventLocationsDao(OfferedEventLocationsDao offeredEventLocationsDao) {
        this.setDao((EntityManagerDao)offeredEventLocationsDao);
    }
}

