/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.EventTopicsDao;
import de.alpharogroup.event.system.entities.EventTemplates;
import de.alpharogroup.event.system.entities.EventTopics;
import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.event.system.service.api.EventTopicsService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="eventTopicsService")
public class EventTopicsBusinessService
extends AbstractBusinessService<EventTopics, Integer, EventTopicsDao>
implements EventTopicsService {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean contains(Topics topic, EventTemplates event) {
        return this.findEventTopic(topic, event) != null;
    }

    @Override
    public EventTopics findEventTopic(Topics topic, EventTemplates event) {
        String hqlString = "select et from EventTopics et where et.event=:event and et.topic=:topic";
        Query query = this.getQuery("select et from EventTopics et where et.event=:event and et.topic=:topic");
        query.setParameter("event", (Object)event);
        query.setParameter("topic", (Object)topic);
        List eventTopics = query.getResultList();
        return (EventTopics)ListExtensions.getFirst((List)eventTopics);
    }

    @Override
    public List<EventTopics> findEventTopics(EventTemplates event) {
        String hqlString = "select et from EventTopics et where et.event=:event";
        Query query = this.getQuery("select et from EventTopics et where et.event=:event");
        query.setParameter("event", (Object)event);
        List eventTopics = query.getResultList();
        return eventTopics;
    }

    @Autowired
    public void setEventTopicsDao(EventTopicsDao eventTopicsDao) {
        this.setDao((EntityManagerDao)eventTopicsDao);
    }
}

