/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.EventTemplatesDao;
import de.alpharogroup.event.system.entities.Categories;
import de.alpharogroup.event.system.entities.EventLocations;
import de.alpharogroup.event.system.entities.EventRatings;
import de.alpharogroup.event.system.entities.EventTemplates;
import de.alpharogroup.event.system.entities.EventTopics;
import de.alpharogroup.event.system.entities.RatingDescriptions;
import de.alpharogroup.event.system.entities.Userevents;
import de.alpharogroup.event.system.service.api.EventLocationsService;
import de.alpharogroup.event.system.service.api.EventMessagesService;
import de.alpharogroup.event.system.service.api.EventRatingsService;
import de.alpharogroup.event.system.service.api.EventTemplatesService;
import de.alpharogroup.event.system.service.api.EventTopicsService;
import de.alpharogroup.event.system.service.api.RatingDescriptionsService;
import de.alpharogroup.event.system.service.api.UsereventsService;
import de.alpharogroup.scheduler.system.entities.Appointments;
import de.alpharogroup.scheduler.system.service.api.AppointmentsService;
import de.alpharogroup.user.entities.Users;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="eventTemplatesService")
public class EventTemplatesBusinessService
extends AbstractBusinessService<EventTemplates, Integer, EventTemplatesDao>
implements EventTemplatesService {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)EventTemplatesBusinessService.class.getName());
    @Autowired
    private EventLocationsService eventLocationsService;
    @Autowired
    private EventTopicsService eventTopicsService;
    @Autowired
    private AppointmentsService appointmentsService;
    @Autowired
    private EventRatingsService eventRatingsService;
    @Autowired
    private RatingDescriptionsService ratingDescriptionsService;
    @Autowired
    private UsereventsService userEventsService;
    @Autowired
    private EventMessagesService eventMessagesService;

    @Override
    public EventTemplates deleteEventAndAllReferences(EventTemplates event) {
        Integer id;
        event.setCategories(null);
        this.merge((BaseEntity)event);
        List<EventLocations> eventLocations = this.eventLocationsService.findEvents(event);
        List<EventTopics> eventTopics = this.eventTopicsService.findEventTopics(event);
        List<EventRatings> eventRatings = this.eventRatingsService.findEventRatings(event);
        List<Userevents> userevents = this.userEventsService.findUserevents(event);
        if (!ListExtensions.isEmpty(eventTopics)) {
            for (EventTopics eventTopic : eventTopics) {
                eventTopic.setTopic(null);
                eventTopic.setEvent(null);
                eventTopic = (EventTopics)this.eventTopicsService.merge((BaseEntity)eventTopic);
                this.eventTopicsService.delete((BaseEntity)eventTopic);
            }
        }
        if (!ListExtensions.isEmpty(userevents)) {
            for (Userevents userevent : userevents) {
                userevent.setEvent(null);
                userevent.setUser(null);
                userevent = (Userevents)this.userEventsService.merge((BaseEntity)userevent);
                this.userEventsService.delete((BaseEntity)userevent);
            }
        }
        if (!ListExtensions.isEmpty(eventRatings)) {
            for (EventRatings eventRating : eventRatings) {
                RatingDescriptions rd = this.eventRatingsService.findRatingDescription(eventRating);
                if (rd != null) {
                    rd.setEventRatings(null);
                    rd = (RatingDescriptions)this.ratingDescriptionsService.merge((BaseEntity)rd);
                    this.ratingDescriptionsService.delete((BaseEntity)rd);
                }
                eventRating.setEvent(null);
                eventRating.setRater(null);
                eventRating = (EventRatings)this.eventRatingsService.merge((BaseEntity)eventRating);
                this.eventRatingsService.delete((BaseEntity)eventRating);
            }
        }
        if (!ListExtensions.isEmpty(eventLocations)) {
            for (EventLocations eventLocation : eventLocations) {
                if (this.eventMessagesService.findEventMessagesFromEventLocation(eventLocation) != null) {
                    eventLocation.setAppointment(null);
                    eventLocation.setEvent(null);
                    eventLocation.setEventLocation(null);
                    continue;
                }
                if (eventLocation.getAppointment() == null) continue;
                Appointments appointment = eventLocation.getAppointment();
                eventLocation.setAppointment(null);
                eventLocation.setEvent(null);
                eventLocation.setEventLocation(null);
                eventLocation.setContactperson(null);
                eventLocation = (EventLocations)this.eventLocationsService.merge((BaseEntity)eventLocation);
                if (appointment != null) {
                    this.appointmentsService.delete((BaseEntity)appointment);
                }
                eventLocation = (EventLocations)this.eventLocationsService.merge((BaseEntity)eventLocation);
                this.eventLocationsService.delete((BaseEntity)eventLocation);
            }
        }
        if (this.exists(id = (Integer)event.getId())) {
            try {
                this.delete((BaseEntity)event);
            }
            catch (Exception e) {
                if (event != null && event.getId() != null) {
                    logger.info((Object)("Exception thrown by tryin delete an event with id:" + event.getId()));
                    logger.info((Object)e.getMessage());
                }
                return event;
            }
        }
        return null;
    }

    @Override
    public EventTemplates findEvent(Users provider, Integer id) {
        String hqlString = "select s from Events as s where s.provider=:provider and s.id=:id";
        Query query = this.getQuery("select s from Events as s where s.provider=:provider and s.id=:id");
        query.setParameter("provider", (Object)provider);
        query.setParameter("id", (Object)id);
        ArrayList events = new ArrayList(new HashSet(query.getResultList()));
        return (EventTemplates)ListExtensions.getFirst(events);
    }

    @Override
    public List<EventTemplates> findEvents(String eventname, Categories category, boolean condition) {
        StringBuilder hqlString = new StringBuilder();
        if (null != category) {
            if (condition) {
                hqlString.append("select s from Events as s where s.name like :eventname and s.categories.name=':category'");
            } else {
                hqlString.append("select s from Events as s where s.name like :eventname or s.categories.name=':category'");
            }
        } else {
            hqlString.append("select s from Events as s where s.name like :eventname");
        }
        Query query = this.getQuery(hqlString.toString());
        query.setParameter("eventname", (Object)eventname);
        if (null != category) {
            query.setParameter("category", (Object)category);
        }
        List foundEvents = query.getResultList();
        return foundEvents;
    }

    @Override
    public List<EventTemplates> findEvents(Users provider) {
        String hqlString = "select distinct ue.event from Userevents ue where ue.user=:provider and ue.relationtype='PROVIDED'";
        Query query = this.getQuery("select distinct ue.event from Userevents ue where ue.user=:provider and ue.relationtype='PROVIDED'");
        query.setParameter("provider", (Object)provider);
        ArrayList<EventTemplates> events = new ArrayList<EventTemplates>(new HashSet(query.getResultList()));
        return events;
    }

    @Autowired
    public void setEventTemplateDao(EventTemplatesDao eventTemplateDao) {
        this.setDao((EntityManagerDao)eventTemplateDao);
    }
}

