/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.EventRatingsDao;
import de.alpharogroup.event.system.entities.EventRatings;
import de.alpharogroup.event.system.entities.EventTemplates;
import de.alpharogroup.event.system.entities.RatingDescriptions;
import de.alpharogroup.event.system.service.api.EventRatingsService;
import de.alpharogroup.rating.system.enums.RatingVisibility;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="eventRatingsService")
public class EventRatingsBusinessService
extends AbstractBusinessService<EventRatings, Integer, EventRatingsDao>
implements EventRatingsService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Users> findAllUsersForRatedEvent(EventTemplates event) {
        String hqlString = "select distinct er.rater from EventRatings er where er.event=:event";
        Query query = this.getQuery("select distinct er.rater from EventRatings er where er.event=:event");
        query.setParameter("event", (Object)event);
        List foundUsers = query.getResultList();
        return foundUsers;
    }

    @Override
    public List<EventRatings> findEventRatings(EventTemplates event) {
        String hqlString = "select er from EventRatings er where er.event=:event";
        Query query = this.getQuery("select er from EventRatings er where er.event=:event");
        query.setParameter("event", (Object)event);
        List foundEventRatings = query.getResultList();
        return foundEventRatings;
    }

    @Override
    public List<EventRatings> findEventRatings(Users subscriber) {
        String hqlString = "select er from EventRatings er where er.rater=:rater";
        Query query = this.getQuery("select er from EventRatings er where er.rater=:rater");
        query.setParameter("rater", (Object)subscriber);
        List foundEventRatings = query.getResultList();
        return foundEventRatings;
    }

    @Override
    public List<EventRatings> findRatedEvents(Users provider) {
        String hqlString = "select er from EventRatings er where er.event.provider=:provider and er.visibility=:visibility";
        Query query = this.getQuery("select er from EventRatings er where er.event.provider=:provider and er.visibility=:visibility");
        query.setParameter("provider", (Object)provider);
        query.setParameter("visibility", (Object)RatingVisibility.INVISIBLE);
        List eventRatings = query.getResultList();
        return eventRatings;
    }

    @Override
    public RatingDescriptions findRatingDescription(EventRatings eventRating) {
        String hqlString = "select rd from RatingDescriptions rd where rd.eventRatings=:eventRating";
        Query query = this.getQuery("select rd from RatingDescriptions rd where rd.eventRatings=:eventRating");
        query.setParameter("eventRating", (Object)eventRating);
        List ratingDescriptions = query.getResultList();
        return (RatingDescriptions)ListExtensions.getFirst((List)ratingDescriptions);
    }

    @Override
    public List<EventRatings> getEventRatingsForEvent(EventTemplates event) {
        String hqlString = "select distinct er from EventRatings er where er.event=:event";
        Query query = this.getQuery("select distinct er from EventRatings er where er.event=:event");
        query.setParameter("event", (Object)event);
        List foundEventRatings = query.getResultList();
        return foundEventRatings;
    }

    @Override
    public List<EventRatings> getEventRatingsForEventFromSubscriber(EventTemplates event, Users subscriber) {
        String hqlString = "select distinct er from EventRatings er where er.event=:event and er.rater=:subscriber";
        Query query = this.getQuery("select distinct er from EventRatings er where er.event=:event and er.rater=:subscriber");
        query.setParameter("event", (Object)event);
        query.setParameter("subscriber", (Object)subscriber);
        List foundEventRatings = query.getResultList();
        return foundEventRatings;
    }

    @Autowired
    public void setEventRatingsDao(EventRatingsDao eventRatingsDao) {
        this.setDao((EntityManagerDao)eventRatingsDao);
    }
}

