/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.EventMessagesDao;
import de.alpharogroup.event.system.entities.EventLocations;
import de.alpharogroup.event.system.entities.EventMessages;
import de.alpharogroup.event.system.service.api.EventMessagesService;
import de.alpharogroup.event.system.service.util.HqlStringCreator;
import de.alpharogroup.message.system.entities.Messages;
import de.alpharogroup.message.system.enums.MessageState;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="eventMessagesService")
public class EventMessagesBusinessService
extends AbstractBusinessService<EventMessages, Integer, EventMessagesDao>
implements EventMessagesService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<EventMessages> find(Messages message, EventLocations eventLocation) {
        String hqlString = HqlStringCreator.forEventMessages(message, eventLocation, EventMessages.class);
        Query query = this.getQuery(hqlString);
        if (message != null) {
            query.setParameter("message", (Object)message);
        }
        if (eventLocation != null) {
            query.setParameter("eventLocation", (Object)eventLocation);
        }
        List eventMessages = query.getResultList();
        return eventMessages;
    }

    @Override
    public EventMessages findEventMessagesFromEventLocation(EventLocations eventLocation) {
        return (EventMessages)ListExtensions.getFirst(this.find(null, eventLocation));
    }

    @Override
    public EventMessages findEventMessagesFromMessage(Messages message) {
        return (EventMessages)ListExtensions.getFirst(this.find(message, null));
    }

    @Override
    public List<EventMessages> findMessages(Users provider) {
        String hqlString = "select distinct em from EventMessages as em join em.eventLocation as sem, Userevents as usev join usev.event as usem  where sem.event.id= usem.id and usev.user=:provider";
        Query query = this.getQuery("select distinct em from EventMessages as em join em.eventLocation as sem, Userevents as usev join usev.event as usem  where sem.event.id= usem.id and usev.user=:provider");
        query.setParameter("provider", (Object)provider);
        List eventMessages = query.getResultList();
        return eventMessages;
    }

    @Override
    public List<EventMessages> findMessages(Users user, MessageState state) {
        String hqlString = "select distinct em from EventMessages as em join em.eventLocation as sem, Userevents as usev join usev.event as usem where sem.event.id=usem.id and usev.user=:user and em.message.state=:state and em.message.deletedFlag=:deletedFlag";
        Query query = this.getQuery("select distinct em from EventMessages as em join em.eventLocation as sem, Userevents as usev join usev.event as usem where sem.event.id=usem.id and usev.user=:user and em.message.state=:state and em.message.deletedFlag=:deletedFlag");
        query.setParameter("user", (Object)user);
        query.setParameter("state", (Object)state);
        query.setParameter("deletedFlag", (Object)Boolean.FALSE);
        List eventMessages = query.getResultList();
        return eventMessages;
    }

    @Autowired
    public void setEventMessagesDao(EventMessagesDao eventMessagesDao) {
        this.setDao((EntityManagerDao)eventMessagesDao);
    }
}

