/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.EventLocationsDao;
import de.alpharogroup.event.system.entities.Categories;
import de.alpharogroup.event.system.entities.EventLocations;
import de.alpharogroup.event.system.entities.EventTemplates;
import de.alpharogroup.event.system.enums.UsereventsRelationType;
import de.alpharogroup.event.system.service.api.EventLocationsService;
import de.alpharogroup.jgeohash.GeoHashExtensions;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.entities.UserDatas;
import de.alpharogroup.user.management.service.api.UserDatasService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="eventLocationsService")
public class EventLocationsBusinessService
extends AbstractBusinessService<EventLocations, Integer, EventLocationsDao>
implements EventLocationsService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UserDatasService userDataService;

    @Override
    public List<Users> findContactPersonsFromProvider(Users provider) {
        String hqlString = "select distinct el.contactperson from EventLocations el, Userevents ue where ue.user=:provider and el.event.id=ue.event.id";
        Query query = this.getQuery("select distinct el.contactperson from EventLocations el, Userevents ue where ue.user=:provider and el.event.id=ue.event.id");
        query.setParameter("provider", (Object)provider);
        ArrayList<Users> contactPersons = new ArrayList<Users>(new HashSet(query.getResultList()));
        return contactPersons;
    }

    @Override
    public EventLocations findEvent(Users provider, EventTemplates event) {
        String hqlString = "select el from EventLocations el, Userevents ue  where ue.user=:provider and ue.event=:event and el.event=:event";
        Query query = this.getQuery("select el from EventLocations el, Userevents ue  where ue.user=:provider and ue.event=:event and el.event=:event");
        query.setParameter("provider", (Object)provider);
        query.setParameter("event", (Object)event);
        List eventLocations = query.getResultList();
        return (EventLocations)ListExtensions.getFirst((List)eventLocations);
    }

    @Override
    public List<EventLocations> findEventLocations(Addresses userAddress) {
        String hqlString = "select ev from EventLocations ev where ev.eventLocation=:userAddress";
        Query query = this.getQuery("select ev from EventLocations ev where ev.eventLocation=:userAddress");
        query.setParameter("userAddress", (Object)userAddress);
        ArrayList<EventLocations> eventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return eventLocations;
    }

    @Override
    public List<EventLocations> findEventLocations(Users user, UsereventsRelationType relationtype) {
        String hqlString = "select distinct el from Userevents ue, EventLocations el where ue.user=:user and ue.relationtype=:relationtype and el.event=ue.event";
        Query query = this.getQuery("select distinct el from Userevents ue, EventLocations el where ue.user=:user and ue.relationtype=:relationtype and el.event=ue.event");
        query.setParameter("user", (Object)user);
        query.setParameter("relationtype", (Object)relationtype);
        List eventLocations = query.getResultList();
        return eventLocations;
    }

    @Override
    public List<EventLocations> findEventLocationsFromEvent(EventTemplates event) {
        String hqlString = "select ev from EventLocations ev where ev.event=:event";
        Query query = this.getQuery("select ev from EventLocations ev where ev.event=:event");
        query.setParameter("event", (Object)event);
        ArrayList<EventLocations> eventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return eventLocations;
    }

    @Override
    public List<Addresses> findEventLocationsFromProvider(Users provider) {
        UserDatas userData = this.userDataService.findBy(provider);
        ArrayList<Addresses> userAdresses = new ArrayList<Addresses>(userData.getAddresses());
        return userAdresses;
    }

    @Override
    public List<EventLocations> findEvents(EventTemplates event) {
        String hqlString = "select distinct el from EventLocations el, Userevents ue  where ue.event=:event  and el.event=:event";
        Query query = this.getQuery("select distinct el from EventLocations el, Userevents ue  where ue.event=:event  and el.event=:event");
        query.setParameter("event", (Object)event);
        ArrayList<EventLocations> eventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return eventLocations;
    }

    @Override
    public List<EventLocations> findEvents(String eventname) {
        StringBuilder sb = new StringBuilder();
        Date systime = new Date();
        Date start = CalculateDateExtensions.addDays((Date)systime, (int)0);
        Date end = CalculateDateExtensions.addDays((Date)systime, (int)30);
        sb.append("select el from EventLocations el where el.event.name like :eventname or el.event.head like :eventname and el.appointment.starttime between :start and :end");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("eventname", (Object)("%" + eventname + "%"));
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        List result = query.getResultList();
        ArrayList<EventLocations> foundEventLocations = new ArrayList<EventLocations>(new HashSet(result));
        return foundEventLocations;
    }

    @Override
    public List<EventLocations> findEvents(String eventname, Categories category, boolean condition) {
        StringBuilder hqlString = new StringBuilder();
        if (null != category) {
            if (condition) {
                hqlString.append("select el from EventLocations el where el.event.name like :eventname and el.event.categories=:category");
            } else {
                hqlString.append("select el from EventLocations el where el.event.name like :eventname or el.event.categories=:category");
            }
        } else {
            hqlString.append("select el from EventLocations el where el.event.name like :eventname");
        }
        Query query = this.getQuery(hqlString.toString());
        query.setParameter("eventname", (Object)eventname);
        if (null != category) {
            query.setParameter("category", (Object)category);
        }
        ArrayList<EventLocations> foundEventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return foundEventLocations;
    }

    @Override
    public List<EventLocations> findEvents(String eventname, Date start, Date end, String geohash) {
        Map adjacentAreas = null;
        if (geohash == null || geohash.isEmpty()) {
            return new ArrayList<EventLocations>();
        }
        adjacentAreas = GeoHashExtensions.getAllAdjacentAreasMap((String)geohash);
        StringBuilder hqlString = new StringBuilder();
        hqlString.append("select el from EventLocations el where el.event.name like :eventname and el.appointment.starttime between :start and :end and el.userAddress.address.geohash in (select address.geohash from Addresses address where address.geohash like :top or address.geohash like :topright or address.geohash like :right or address.geohash like :bottomright or address.geohash like :bottom or address.geohash like :bottomleft or address.geohash like :left or address.geohash like :topleft or address.geohash like :center )");
        String queryString = hqlString.toString();
        Query query = this.getQuery(queryString);
        query.setParameter("eventname", (Object)("%" + eventname + "%"));
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        for (Map.Entry entry : adjacentAreas.entrySet()) {
            query.setParameter((String)entry.getKey(), (Object)((String)entry.getValue() + "%"));
        }
        ArrayList<EventLocations> foundEventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return foundEventLocations;
    }

    @Override
    public List<EventLocations> findEvents(Users provider) {
        String hqlString = "select el from EventLocations el, Userevents ue  where ue.user=:provider and el.event.id=ue.event.id";
        Query query = this.getQuery("select el from EventLocations el, Userevents ue  where ue.user=:provider and el.event.id=ue.event.id");
        query.setParameter("provider", (Object)provider);
        ArrayList<EventLocations> eventLocations = new ArrayList<EventLocations>(new HashSet(query.getResultList()));
        return eventLocations;
    }

    @Autowired
    public void setEventLocationsDao(EventLocationsDao eventLocationsDao) {
        this.setDao((EntityManagerDao)eventLocationsDao);
    }
}

