/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.event.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.event.system.daos.CategoriesDao;
import de.alpharogroup.event.system.entities.Categories;
import de.alpharogroup.event.system.service.api.CategoriesService;
import de.alpharogroup.event.system.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="categoriesService")
public class CategoriesBusinessService
extends AbstractBusinessService<Categories, Integer, CategoriesDao>
implements CategoriesService {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean existsCategory(String name) {
        return this.findCategory(name) != null;
    }

    @Override
    public List<Categories> find(String name) {
        String hqlString = HqlStringCreator.forCategories(name, Categories.class);
        Query query = this.getQuery(hqlString);
        if (name != null) {
            query.setParameter("name", (Object)name);
        }
        List categories = query.getResultList();
        return categories;
    }

    @Override
    public Categories findCategory(String name) {
        return (Categories)ListExtensions.getFirst(this.find(name));
    }

    @Autowired
    public void setCategoriesDao(CategoriesDao categoriesDao) {
        this.setDao((EntityManagerDao)categoriesDao);
    }
}

