/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entity.delete;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entity.delete.IdentifiableDeletable;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="deletion")
public class Deletion<PK extends Serializable, T, U>
extends BaseEntity<PK>
implements IdentifiableDeletable<PK, T, U> {
    private static final long serialVersionUID = 1L;
    private T deleted;
    private U deletedBy;

    public static <PK extends Serializable, T, U> DeletionBuilder<PK, T, U> builder() {
        return new DeletionBuilder();
    }

    public DeletionBuilder<PK, T, U> toBuilder() {
        return new DeletionBuilder().deleted(this.deleted).deletedBy(this.deletedBy);
    }

    public T getDeleted() {
        return this.deleted;
    }

    public U getDeletedBy() {
        return this.deletedBy;
    }

    public void setDeleted(T deleted) {
        this.deleted = deleted;
    }

    public void setDeletedBy(U deletedBy) {
        this.deletedBy = deletedBy;
    }

    @Override
    public String toString() {
        return "Deletion(deleted=" + this.getDeleted() + ", deletedBy=" + this.getDeletedBy() + ")";
    }

    public Deletion() {
    }

    public Deletion(T deleted, U deletedBy) {
        this.deleted = deleted;
        this.deletedBy = deletedBy;
    }

    public static class DeletionBuilder<PK extends Serializable, T, U> {
        private T deleted;
        private U deletedBy;

        DeletionBuilder() {
        }

        public DeletionBuilder<PK, T, U> deleted(T deleted) {
            this.deleted = deleted;
            return this;
        }

        public DeletionBuilder<PK, T, U> deletedBy(U deletedBy) {
            this.deletedBy = deletedBy;
            return this;
        }

        public Deletion<PK, T, U> build() {
            return new Deletion(this.deleted, this.deletedBy);
        }

        public String toString() {
            return "Deletion.DeletionBuilder(deleted=" + this.deleted + ", deletedBy=" + this.deletedBy + ")";
        }
    }
}

