/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entity.treeable;

import de.alpharogroup.db.entity.base.SequenceBaseEntity;
import de.alpharogroup.db.entity.treeable.Treeable;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class TreeableEntity<PK extends Serializable, T, TR extends Treeable<PK, T, ?>>
extends SequenceBaseEntity<PK>
implements Cloneable,
Treeable<PK, T, TR> {
    private static final long serialVersionUID = 1L;
    @Column(name="depth")
    private int depth;
    @Column(name="node")
    private boolean node;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="parent_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_treeable_parent_id"))
    private TR parent;
    @Column(name="value", columnDefinition="TEXT")
    private T value;

    protected TreeableEntity(TreeableEntityBuilder<PK, T, TR, ?, ?> b) {
        super(b);
        this.depth = ((TreeableEntityBuilder)b).depth;
        this.node = ((TreeableEntityBuilder)b).node;
        this.parent = ((TreeableEntityBuilder)b).parent;
        this.value = ((TreeableEntityBuilder)b).value;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isNode() {
        return this.node;
    }

    public TR getParent() {
        return this.parent;
    }

    public T getValue() {
        return this.value;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setNode(boolean node) {
        this.node = node;
    }

    public void setParent(TR parent) {
        this.parent = parent;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public TreeableEntity() {
    }

    public TreeableEntity(int depth, boolean node, TR parent, T value) {
        this.depth = depth;
        this.node = node;
        this.parent = parent;
        this.value = value;
    }

    public static abstract class TreeableEntityBuilder<PK extends Serializable, T, TR extends Treeable<PK, T, ?>, C extends TreeableEntity<PK, T, TR>, B extends TreeableEntityBuilder<PK, T, TR, C, B>>
    extends SequenceBaseEntity.SequenceBaseEntityBuilder<PK, C, B> {
        private int depth;
        private boolean node;
        private TR parent;
        private T value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B depth(int depth) {
            this.depth = depth;
            return (B)this.self();
        }

        public B node(boolean node) {
            this.node = node;
            return (B)this.self();
        }

        public B parent(TR parent) {
            this.parent = parent;
            return (B)this.self();
        }

        public B value(T value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TreeableEntity.TreeableEntityBuilder(super=" + super.toString() + ", depth=" + this.depth + ", node=" + this.node + ", parent=" + this.parent + ", value=" + this.value + ")";
        }
    }
}

