/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.email.data.sources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private final ByteArrayOutputStream outputStream;
    private final String contentType;

    public ByteArrayDataSource(byte[] byteArray, String contenttype) {
        this.contentType = contenttype;
        int len = byteArray.length;
        this.outputStream = new ByteArrayOutputStream(len);
        this.outputStream.write(byteArray, 0, len);
    }

    public byte[] getByteArray() {
        return this.outputStream.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    public String getName() {
        return this.getClass().getCanonicalName();
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getContentType() {
        return this.contentType;
    }
}

