/**
 * The MIT License
 *
 * Copyright (C) 2007 Asterios Raptis
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package de.alpharogroup.email.messages;

/**
 * The class EmailConstants for constants.
 */
public abstract class EmailConstants
{

	/** Constant for the charset-prefix. */
	public static final String CHARSET_PREFIX = "; charset=";

	/** Constant for the charset 'UTF-8'. */
	public static final String CHARSET_UTF8 = "UTF-8";

	/** Constant for the name from the properties-file. */
	public static final String PROPERTIES_FILENAME = "mail.properties";

	/** Constant for the mimetype text/html. */
	public static final String MIMETYPE_TEXT_HTML = "text/html";

	/** Constant for the mimetype text/plain. */
	public static final String MIMETYPE_TEXT_PLAIN = "text/plain";

}