/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entitymapper;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityBOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.lang.TypeArgumentsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.dozer.MappingException;

public abstract class AbstractEntityBOMapper<E extends BaseEntity<?>, BO extends DomainObject<?>>
implements EntityBOMapper<E, BO> {
    private final Mapper mapper;
    private final Class<E> entityClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)0);
    private final Class<BO> domainObjectClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)1);

    public AbstractEntityBOMapper() {
        this(Collections.emptyList());
    }

    public AbstractEntityBOMapper(List<String> mappingFiles) {
        this.mapper = this.newMapper(mappingFiles);
    }

    public Mapper newMapper(List<String> mappingFiles) {
        return new DozerBeanMapper(mappingFiles);
    }

    @Override
    public BO toDomainObject(E entity) {
        if (entity != null) {
            return (BO)((DomainObject)this.mapper.map(entity, this.getDomainObjectClass()));
        }
        return null;
    }

    @Override
    public List<BO> toDomainObjects(List<E> entities) {
        ArrayList<BO> domainObjects = new ArrayList<BO>();
        if (entities != null && !entities.isEmpty()) {
            for (BaseEntity entity : entities) {
                domainObjects.add(this.toDomainObject(entity));
            }
        }
        return domainObjects;
    }

    @Override
    public List<E> toEntities(List<BO> domainObjects) {
        ArrayList<E> entities = new ArrayList<E>();
        if (domainObjects != null && !domainObjects.isEmpty()) {
            for (DomainObject domainObject : domainObjects) {
                entities.add(this.toEntity(domainObject));
            }
        }
        return entities;
    }

    @Override
    public E toEntity(BO domainObject) {
        if (domainObject != null) {
            return (E)((BaseEntity)this.mapper.map(domainObject, this.getEntityClass()));
        }
        return null;
    }

    @Override
    public <T, S> T map(S source, Class<T> destinationClass) throws MappingException {
        return (T)this.getMapper().map(source, destinationClass);
    }

    @Override
    public <T, S> List<T> map(List<S> sources, Class<T> destinationClass) throws MappingException {
        ArrayList<T> destination = new ArrayList<T>();
        if (sources != null && !sources.isEmpty()) {
            for (S source : sources) {
                destination.add(this.map(source, destinationClass));
            }
        }
        return destination;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<BO> getDomainObjectClass() {
        return this.domainObjectClass;
    }
}

