/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.domain;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import de.alpharogroup.service.domain.DomainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDomainService<PK extends Serializable, DO extends DomainObject<PK>, E extends BaseEntity<PK>, DAO extends EntityManagerDao<E, PK>, M extends EntityDOMapper<E, DO>>
implements DomainService<PK, DO> {
    private DAO dao;
    private M mapper;
    private final Class<E> entityClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)2);
    private final Class<DO> domainObjectClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)1);

    @Override
    public DO read(PK id) {
        BaseEntity entity = this.dao.get(id);
        return this.getMapper().toDomainObject((BaseEntity)entity);
    }

    @Override
    public DO create(DO domainObject) {
        Object entity = this.getMapper().toEntity(domainObject);
        domainObject.setId((Serializable)this.dao.save(entity));
        return domainObject;
    }

    @Override
    public void update(DO domainObject) {
        BaseEntity entity = this.dao.get((Serializable)domainObject.getId());
        ObjectExtensions.copyQuietly((Object)entity, domainObject);
        this.dao.merge(entity);
    }

    @Override
    public void delete(PK id) {
        this.dao.delete(id);
    }

    @Override
    public List<DO> findAll() {
        List all = this.dao.findAll();
        ArrayList domainObjects = new ArrayList();
        for (BaseEntity entity : all) {
            domainObjects.add(this.getMapper().toDomainObject((BaseEntity)entity));
        }
        return domainObjects;
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public M getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<DO> getDomainObjectClass() {
        return this.domainObjectClass;
    }
}

