/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.strategies;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.repository.AbstractRepository;
import de.alpharogroup.db.strategies.api.MergeStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.springframework.transaction.annotation.Transactional;

public class DefaultMergeStrategy<T extends BaseEntity<PK>, PK extends Serializable>
implements MergeStrategy<T, PK> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final AbstractRepository<T, PK> repository;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(DefaultMergeStrategy.class, this.getClass());

    public DefaultMergeStrategy(AbstractRepository<T, PK> repository) {
        this.repository = repository;
    }

    private EntityManager getEntityManager() {
        return this.repository.getEntityManager();
    }

    @Override
    public List<T> merge(List<T> objects) {
        ArrayList<BaseEntity> mergedEntities = new ArrayList<BaseEntity>();
        for (BaseEntity object : objects) {
            mergedEntities.add(this.merge(object));
        }
        return mergedEntities;
    }

    @Override
    @Transactional
    public T merge(T entity) {
        return (T)((BaseEntity)this.getEntityManager().merge(entity));
    }

    public Class<T> getType() {
        return this.type;
    }
}

