/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.strategies;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.strategies.api.SaveOrUpdateStrategy;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;

public class DefaultDaoSaveOrUpdateStrategy<T extends BaseEntity<PK>, PK extends Serializable>
implements SaveOrUpdateStrategy<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsExtensions.getFirstTypeArgument(DefaultDaoSaveOrUpdateStrategy.class, this.getClass());
    @NonNull
    private final EntityManagerDao<T, PK> dao;

    public DefaultDaoSaveOrUpdateStrategy(EntityManagerDao<T, PK> dao) {
        this.dao = dao;
    }

    private EntityManager getEntityManager() {
        return this.dao.getEntityManager();
    }

    @Override
    public List<PK> save(List<T> entities) {
        ArrayList<PK> primaryKeys = new ArrayList<PK>();
        for (BaseEntity entity : entities) {
            primaryKeys.add(this.save(entity));
        }
        return primaryKeys;
    }

    @Override
    public PK save(T entity) {
        this.getEntityManager().persist(entity);
        return ((BaseEntity)entity).getId();
    }

    @Override
    public void saveOrUpdate(List<T> entities) {
        for (BaseEntity entity : entities) {
            this.saveOrUpdate(entity);
        }
    }

    @Override
    public void saveOrUpdate(T entity) {
        if (((BaseEntity)entity).getId() == null) {
            this.save(entity);
        } else {
            this.update(entity);
        }
    }

    @Override
    public void update(List<T> entities) {
        for (BaseEntity entity : entities) {
            this.update(entity);
        }
    }

    @Override
    public void update(T entity) {
        this.getEntityManager().merge(entity);
    }

    public Class<T> getType() {
        return this.type;
    }
}

